<?php
class Erado_Instagram extends WP_Widget {
	function __construct() {
		$widget_ops  = array(
			'classname' => 'jms-instagram',
			'description' => esc_html__( 'Show off your favorite Instagram photos', 'erado' )
		);

		parent::__construct( 'jms-instagram', esc_html__('JMS - Instagram', 'erado'), $widget_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title   = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$token   = empty( $instance['token'] ) ? '' : esc_attr($instance['token']);
		$limit   = empty( $instance['limit'] ) ? 4 : ( int ) $instance['limit'];
		$columns = empty( $instance['columns'] ) ? 2 : ( int ) $instance['columns'];

		echo '' . $before_widget;

		if ( ! empty( $title ) ) {
			echo '' . $before_title . $title . $after_title;
		}

		$characters = '0123456789';
        $random_key = '';
        for ($i = 0; $i < $length; $i++) {
            $random_key .= $characters[rand(0, strlen($characters) - 1)];
        }

		$transient_var = $random_key . '_' . $limit;

		if ( false === ( $items = get_transient( $transient_var ) ) && ! empty( $token ) ) {

			$api = add_query_arg(
                array(
                    'fields' => 'id,media_type,media_url,permalink,likes,username,timestamp',
                    'access_token'         => $token,
                    'limit' => $limit
                ),
                'https://graph.instagram.com/me/media'
			);
			$getphoto = wp_remote_get( $api );

			if ( is_wp_error( $getphoto ) || 200 != wp_remote_retrieve_response_code( $getphoto ) ) {
			    echo '<p>'. esc_html__('Incorrect token specified.', 'erado') .'</p>';
            }else{
            	$photos = json_decode( wp_remote_retrieve_body( $getphoto ), true);

            	if (isset($photos['data']) && count($photos['data'])) {
                        $items = array();
                        foreach ( $photos['data'] as $media ) {
                            if ($media['media_type'] === 'IMAGE') {
                                $items[] = $media;
                            }elseif($media['media_type'] === 'CAROUSEL_ALBUM'){
                                $album = wp_remote_get(
                                    add_query_arg(
                                        array(
                                            'fields' => 'id,media_type,media_url,permalink,likes,username,timestamp',
                                            'access_token'         => $token,
                                        ),
                                       "https://graph.instagram.com/{$media['id']}/children"
                                    )
                                );
                                if ( !is_wp_error( $album ) || 200 === wp_remote_retrieve_response_code( $album ) ) {
                                    $album_obj = json_decode( wp_remote_retrieve_body( $getphoto ), true);
                                     if (isset($album_obj['data']) && count($album_obj['data'])) {
                                        foreach ($album_obj['data'] as $children) {
                                            if ($children['media_type'] == "IMAGE") {
                                                $items[] =  $children;
                                                if (count($items) >= $limit) break;
                                            }
                                        }
                                    }
                                }
                            }
                            if (count($items) >= $limit) break;
                        }

                        $items_instagram = array();

						if ( isset( $items ) ) {
							foreach ( $items as $item ) {
								$instagram['link']     		= $item['permalink'];
								$instagram['src']      		= $item['media_url'];
								$items_instagram[]      	= $instagram;
								
							}

							set_transient( $transient_var, $items_instagram, 60 * 60 );
						}                                            		
            	}
            }
		}

		$output = '<div class="instagram clearfix cols-' . esc_attr( $columns ) . '">';

		if ( isset( $items ) && $items ) {
			foreach ( $items as $item ) {
				$link    = $item['link'];
				$image   = $item['src'];
				$output .= '<div class="item"><a target="_blank" href="' . esc_url( $link ) .'"><img width="320" height="320" class="img-responsive" src="' . esc_url( $image ) . '" alt="'. esc_html__('Instagram', 'erado') .'" /></a></div>';
			}
		}

		$output .= '</div>';

		echo '' . $output . $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance            = $old_instance;
		$instance['title']   = sanitize_text_field( $new_instance['title'] );
		$instance['id']      = sanitize_text_field($new_instance['id']);
		$instance['token']   = sanitize_text_field($new_instance['token']);
		$instance['limit']   = intval( $new_instance['limit'] );
		$instance['columns'] = intval( $new_instance['columns'] );

		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( ( array ) $instance, array( 'title' => '', 'token' => '', 'limit' => 4, 'columns' => 2 ) );
		$title    = esc_attr( $instance['title'] );
		$token    = isset( $instance['token'] ) ? esc_attr($instance['token']) : array();
		$limit    = ( int ) $instance['limit'];
		$columns  = ( int ) $instance['columns'];
		$generate_token = 'https://www.wpzoom.com/instagram-auth';
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'erado' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'token' )); ?>"><?php echo sprintf( __( 'Access token (<a href="%1$s" target="_blank">Generate access token</a>)', 'erado' ), $generate_token ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'token' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'token' )); ?>" type="text" value="<?php echo esc_attr($token); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'limit' )); ?>"><?php esc_html_e( 'Number of Photos:', 'erado' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'limit' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'limit' )); ?>" type="number" min="1" value="<?php echo intval( $limit ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'columns' )); ?>"><?php esc_html_e( 'Columns (1-5):', 'erado' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'columns' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'columns' )); ?>" type="number" min="1" max="5" step="1" value="<?php echo intval( $columns ); ?>" />
		</p>
		<?php
	}
}

function erado_register_instagram() {
	register_widget( 'Erado_Instagram' );
}
add_action( 'widgets_init', 'erado_register_instagram' );
