<?php
$items_mobile = $items_tablet = $items_medium = $items_show = $banner_text_3 = $items_space = $show_pagination = $show_navigation = $autoplay = $loop = $autoplaytimeout = '';

$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );
if ( isset($style_navigation) && $style_navigation == '2' ) {
    $el_class[] = 'big-arrow';
}
extract($atts);
if ( !empty($atts['extra_class']) ) {
    $el_class[] = $atts['extra_class'];
}
?>
<div id="jmsbrand-box" class="<?php echo implode(' ', $el_class) ?>">
	<?php if( isset( $title ) && ! empty( $title ) ) : ?>
        <div class="addon-title mb_40">
            <h3><?php echo esc_attr($title); ?></h3>
            <?php if( isset( $description_addon ) && ! empty( $description_addon ) ) : ?>
                <p class="description"><?php echo esc_attr($description_addon); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
	<div class="brand-carousel-<?php echo intval($rd_number); ?> owl-carousel owl-theme">
		<?php
		$images = explode( ',', $atts['brand_image'] );

		foreach($images as $image_id){
			$_image_brand = wp_get_attachment_image_src( $image_id, 'full' );
			$image_brand = $_image_brand[0];

			$image_alt = '';
	        $image_alt = get_post_meta( $atts['brand_image'], '_wp_attachment_image_alt', true);

			?>
			<div class="item tc">
	            <img src="<?php echo $image_brand; ?>" alt="<?php echo $image_alt; ?>" class="img-responsive">
	        </div>
			<?php
		}
		?>
	</div>
</div>
<script type="text/javascript">
	jQuery(document).ready(function($) {
	    var owl_brand = $('.brand-carousel-<?php echo intval($rd_number); ?>');
		var rtl = false;
    	if ($('body').hasClass('rtl')) rtl = true;

	    owl_brand.owlCarousel({
            responsive : {
                320 : {
	        		items: 1,
                    margin: 30
	        	},
				480 : {
	        		items: <?php if( (int) $items_mobile > 0) { echo esc_js($items_mobile); } else { echo '2'; } ?>,
                    margin: 30
	        	},
			    768 : {
			        items: <?php if( (int) $items_tablet > 0) { echo esc_js($items_tablet); } else { echo '2'; } ?>,
                    margin: 30
			    },
			    991 : {
			        items: <?php if( (int) $items_medium > 0) { echo esc_js($items_medium); } else { echo '3'; } ?>,
                    margin: 30
			    },
			    1199 : {
			        items: <?php if( (int) $items_show > 0) { echo esc_js($items_show); } else { echo '4'; } ?>,
			    }
			},
			rtl: rtl,
	        margin: <?php if( (int) $items_space > 0) { echo esc_js($items_space); } else { echo '30'; } ?>,
	        dots: <?php if( $show_pagination == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        nav: <?php if( $show_navigation == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplay: <?php if( $autoplay == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        loop: <?php if( $loop == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplayTimeout: <?php if( (int) $autoplaytimeout > 0 ) { echo esc_js($autoplaytimeout); } else { echo '5000'; } ?>,
	        smartSpeed: 1000,
			navText: ['<i class="icon-arrow prev"></i>','<i class="icon-arrow next"></i>']
	    });
	});
</script>