<?php
if ( !class_exists( 'WooCommerce' ) ) return;

$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract( $atts );

if ( !empty($extra_class) ) {
    $el_class[] = $extra_class;
}

$el_class[] = 'jmsproduct-category jmsproduct-box';

$el_class[] = 'effect-product-'.$hover_image;
if ( isset($style_navigation) && $style_navigation == '2' ) {
    $el_class[] = 'big-arrow';
}

$categories = explode(",", $category);
$category_products = array();

foreach($categories as $category_id){
    $args = array(
        'post_type'             => 'product',
        'post_status'           => 'publish',
        'ignore_sticky_posts'   => 1,
        'posts_per_page'        => 10,
        'orderby'               => $orderby,
        'order'                 => $order,
        'tax_query'             => array(
            array(
                'taxonomy'      => 'product_cat',
                'field'         => 'term_id',
                'terms'         => $category_id,
            )
        )
    );
    $product = get_term_by( 'id', $category_id, 'product_cat' );
    $link_cates = get_category_link( $category_id );
    $category_products[] = array(
        'products' => new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts )),
        'category_name' => get_the_category_by_ID($category_id),
        'link_cate' => $link_cates,
    );
}

// Don't show carousel
if ( $show_hide_carousel == 'no' ){
    $el_class2[] = 'jmsproductlist';
}

if ( !empty($number_of_columns) ) {
    $el_class2[] = 'product-col-' . $number_of_columns;
}

// Magin wrapper
$product_list = array();
$product_list[] = 'product-list-wrapper';
if ( !empty($columns_gap) ) {
    $product_list[] = 'ml_-' . ceil($columns_gap / 2) . ' mr_-' . ceil($columns_gap / 2);
}

// Padding Item
$item_class = array();
$item_class2[] = 'item item-wrapper';
if ( !empty($columns_gap) ) {
    $item_class2[] = 'pl_' . ceil($columns_gap / 2) . ' pr_' . ceil($columns_gap / 2);
}

if ( (!empty($productbox_style) && $productbox_style == 2 ) && $columns_gap > 0 ) {
    $item_class2[] = 'mb_' . $columns_gap;
}

if ( isset($product_style) && $product_style == '2' ) {
    $item_class[] = 'product-style-2';
} else {
    $item_class[] = 'product-style-1';
}


?>
<div class="<?php echo implode(' ', $el_class) ?>">
    <?php if( isset( $title ) && ! empty( $title ) ) : ?>
        <div class="addon-title mb_40">
            <h3><?php echo esc_attr($title); ?></h3>
            <?php if( isset( $description_addon ) && ! empty( $description_addon ) ) : ?>
                <p class="description"><?php echo esc_attr($description_addon); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php if ( $show_hide_carousel == 'yes' ) { ?>
        <div class="product-carousel-<?php echo intval($rd_number); ?> owl-carousel owl-theme">
        <?php foreach($category_products as $category_product) { ?>
            <?php if ( $category_product['products']->have_posts() ) :?>
                <?php $row = 1;?>
                <?php while ( $category_product['products']->have_posts() ) : $category_product['products']->the_post(); ?>
                    <?php if($row == 1) : ?>
                        <div class="item-wrap">
                    <?php endif; ?>
                        <div class="item <?php echo implode(' ', $item_class); ?>">
                            <?php wc_get_template_part( 'content', 'product' ); ?>
                        </div>
                    <?php if( $row == (int) $atts['number_of_rows'] || $category_product['products']->current_post+1 == $category_product['products']->post_count) { $row=0; ?>
                        </div>
                    <?php } $row++;?>
                <?php endwhile; // end of the loop. ?>
            <?php endif;
            wp_reset_postdata();?>
        <?php } ?>
    </div>
    <?php } else { ?>
    <div class="<?php echo implode(' ', $el_class2) ?>">
        <div class="<?php echo implode(' ', $product_list); ?>">
            <?php foreach($category_products as $category_product) { ?>
                <?php if ( $category_product['products']->have_posts() ) :?>
                    <?php while ( $category_product['products']->have_posts() ) : $category_product['products']->the_post(); ?>
                        <div class="<?php echo implode(' ', $item_class2); ?> <?php echo implode(' ', $item_class); ?>">
                            <?php wc_get_template_part( 'content', 'product' ); ?>
                        </div>
                    <?php endwhile; // end of the loop. ?>
                <?php endif;
                wp_reset_postdata();?>
            <?php } ?>
        </div>
    </div>
    <?php } ?>
</div>
<script>
    jQuery(document).ready(function($) {
        var owl_product = $('.product-carousel-<?php echo intval($rd_number); ?>');
        var rtl = false;
        if ($('body').hasClass('rtl')) rtl = true;

        owl_product.owlCarousel({
            responsive : {
                320 : {
                    items: 1,
                    margin: 30
                },
                480 : {
                    items: <?php if( (int) $items_mobile > 0) { echo esc_js($items_mobile); } else { echo '2'; } ?>,
                    margin: 30
                },
                768 : {
                    items: <?php if( (int) $items_tablet > 0) { echo esc_js($items_tablet); } else { echo '2'; } ?>,
                    margin: 30
                },
                991 : {
                    items: <?php if( (int) $items_medium > 0) { echo esc_js($items_medium); } else { echo '3'; } ?>,
                    margin: 30
                },
                1199 : {
                    items: <?php if( (int) $items_show > 0) { echo esc_js($items_show); } else { echo '4'; } ?>,
                }
            },
            rtl: rtl,
            margin: <?php if( (int) $items_space > 0) { echo esc_js($items_space); } else { echo '30'; } ?>,
            dots: <?php if( $show_pagination == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
            nav: <?php if( $show_navigation == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
            autoplay: <?php if( $autoplay == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
            loop: <?php if( $loop == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
            autoplayTimeout: <?php if( (int) $autoplaytimeout > 0 ) { echo esc_js($autoplaytimeout); } else { echo '5000'; } ?>,
            smartSpeed: 1000,
            navText: ['<i class="icon-arrow prev"></i>','<i class="icon-arrow next"></i>']
        });
    });
</script>
