<?php
if ( !class_exists( 'WooCommerce' ) ) return;

$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract( $atts );

if ( !empty($extra_class) ) {
    $el_class[] = $extra_class;
}
$el_class[] = 'effect-product-'.$hover_image;
if ( isset($style_navigation) && $style_navigation == '2' ) {
    $el_class[] = 'big-arrow';
}
// Global Query
$args = array(
    'post_type'				=> 'product',
    'post_status'			=> 'publish',
    'ignore_sticky_posts'	=> 1,
    'posts_per_page' 		=> $total_items,
);
$args['meta_query'] = WC()->query->get_meta_query();
$tax_query   		= WC()->query->get_tax_query();

//recent products
$recent_args = $args;
$recent_args['orderby'] = $orderby;
$recent_args['order'] = $order;
$recent_args['tax_query'] = $tax_query;

$recent_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $recent_args, $atts ) );

//featured products
$f_tax_query[] = array(
    'taxonomy' => 'product_visibility',
    'field'    => 'name',
    'terms'    => 'featured',
    'operator' => 'IN',
);

$featured_args				= $args;
$featured_args['orderby'] 	= $orderby;
$featured_args['order'] 	= $order;
$featured_args['tax_query']	= $f_tax_query;

$featured_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $featured_args, $atts ) );

//best selling
$best_selling_args				= $args;
$best_selling_args['meta_key'] 	= 'total_sales';
$best_selling_args['orderby'] 	= 'meta_value_num';
$best_selling_args['tax_query']	= $tax_query;

$best_selling_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $best_selling_args, $atts ) );

//sale products
$product_ids_on_sale = wc_get_product_ids_on_sale();
$sale_args				= $args;
$sale_args['orderby'] 	= $orderby;
$sale_args['order'] 	= $order;
$sale_args['tax_query']	= $tax_query;
$sale_args['post__in'] 	= array_merge( array( 0 ), $product_ids_on_sale );

$sale_products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $sale_args, $atts ) );

// Don't show carousel
if ( $show_hide_carousel == 'no' ){
    $el_class2[] = 'jmsproductlist';
}

if ( !empty($number_of_columns) ) {
    $el_class2[] = 'product-col-' . $number_of_columns;
}

// Magin wrapper
$product_list = array();
$product_list[] = 'product-list-wrapper';
if ( !empty($columns_gap) ) {
    $product_list[] = 'ml_-' . ceil($columns_gap / 2) . ' mr_-' . ceil($columns_gap / 2);
}

// Padding Item
$item_class = array();
$item_class2[] = 'item item-wrapper';
if ( !empty($columns_gap) ) {
    $item_class2[] = 'pl_' . ceil($columns_gap / 2) . ' pr_' . ceil($columns_gap / 2);
}

if ( (!empty($productbox_style) && $productbox_style == 2 ) && $columns_gap > 0 ) {
    $item_class2[] = 'mb_' . $columns_gap;
}

if ( isset($product_style) && $product_style == '2' ) {
    $item_class[] = 'product-style-2';
} else {
    $item_class[] = 'product-style-1';
}


?>

<div id="jmsproducttab-box" class="<?php echo implode(' ', $el_class) ?>">
    <?php if( isset( $title ) && ! empty( $title ) ) : ?>
        <div class="addon-title mb_40">
            <h3><?php echo esc_attr($title); ?></h3>
            <?php if( isset( $description_addon) && ! empty( $description_addon ) ) : ?>
                <p class="description"><?php echo esc_attr($description_addon); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <div class="nav-wrap">
        <?php $t = 0;?>
        <ul class="nav nav-tabs tab-product">
            <?php if ( $recent_products->have_posts() && ( $show_new == 'show' ) ) :?>
                <li <?php echo  $t == 0 ? 'class="active"': '' ?>>
                    <a class="name-tabproduct" href="#tab-new" data-toggle="tab"><?php if ( !empty($title_new) ){ echo esc_attr($title_new);} ?></a>
                </li>
                <?php $t++;
            endif;
            if ( $featured_products->have_posts() && ( $show_featured == 'show' ) ) :?>
                <li <?php echo  $t == 0 ? 'class="active"': '' ?>>
                    <a class="name-tabproduct" href="#tab-featured" data-toggle="tab"><?php if ( !empty($title_featured) ){ echo esc_attr($title_featured);} ?></a>
                </li><?php $t++;
            endif;
            if ( $best_selling_products->have_posts() && ( $show_bestseller == 'show' ) ) :?>
                <li <?php echo  $t == 0 ? 'class="active"': '' ?>>
                    <a class="name-tabproduct" href="#tab-bestseller" data-toggle="tab"><?php if ( !empty($title_bestseller) ){ echo esc_attr($title_bestseller);} ?></a>
                </li><?php $t++;
            endif;

            if ( $sale_products->have_posts() && ( $show_sale == 'show' ) ) :?>
                <li <?php echo  $t == 0 ? 'class="active"': '' ?>>
                    <a class="name-tabproduct" href="#tab-onsale" data-toggle="tab"><?php if ( !empty($title_sale) ){ echo esc_attr($title_sale);} ?></a>
                </li><?php $t++;
            endif;
            ?>
        </ul>
    </div>

    <div class="tab-content">
        <?php $p = 0;
        if ( $recent_products->have_posts() && ( $show_new == 'show' ) ) :?>
            <div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="tab-new">
                <?php if ( $show_hide_carousel == 'yes' ) { ?>
                    <div class="owl-carousel owl-theme producttab-carousel">
                        <?php if ( $recent_products->have_posts() ) :?>
                            <?php $row = 1;?>
                            <?php while ( $recent_products->have_posts() ) : $recent_products->the_post(); ?>
                                <?php if($row == 1) : ?>
                                    <div class="item-wrap">
                                <?php endif; ?>
                                    <div class="item <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php if( $row == (int) $atts['number_of_rows'] || $recent_products->current_post+1 == $recent_products->post_count) { $row=0; ?>
                                    </div>
                                <?php } $row++;?>
                            <?php endwhile; // end of the loop. ?>
                        <?php endif;
                        wp_reset_postdata();?>
                    </div>
                <?php } else { ?>
                    <div class="<?php echo implode(' ', $el_class2) ?>">
                        <div class="<?php echo implode(' ', $product_list); ?>">
                            <?php if ( $recent_products->have_posts() ) :?>
                                <?php while ( $recent_products->have_posts() ) : $recent_products->the_post(); ?>
                                    <div class="<?php echo implode(' ', $item_class2); ?> <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php endwhile; // end of the loop. ?>
                            <?php endif;
                            wp_reset_postdata();?>
                        </div>
                    </div>
                <?php } ?>
                <?php $p++; ?>
            </div>
        <?php endif;
        if ( $featured_products->have_posts() && ( $show_featured == 'show' ) ) :?>
            <div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="tab-featured">
                <?php if ( $show_hide_carousel == 'yes' ) { ?>
                    <div class="owl-carousel owl-theme producttab-carousel">
                        <?php if ( $featured_products->have_posts() ) :?>
                            <?php $row = 1;?>
                            <?php while ( $featured_products->have_posts() ) : $featured_products->the_post(); ?>
                                <?php if($row == 1) : ?>
                                    <div class="item-wrap">
                                <?php endif; ?>
                                    <div class="item <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php if( $row == (int) $atts['number_of_rows'] || $featured_products->current_post+1 == $featured_products->post_count) { $row=0; ?>
                                    </div>
                                <?php } $row++;?>
                            <?php endwhile; // end of the loop. ?>
                        <?php endif;
                        wp_reset_postdata();?>
                    </div>
                <?php } else { ?>
                    <div class="<?php echo implode(' ', $el_class2) ?>">
                        <div class="<?php echo implode(' ', $product_list); ?>">
                            <?php if ( $featured_products->have_posts() ) :?>
                                <?php while ( $featured_products->have_posts() ) : $featured_products->the_post(); ?>
                                    <div class="<?php echo implode(' ', $item_class2); ?> <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php endwhile; // end of the loop. ?>
                            <?php endif;
                            wp_reset_postdata();?>
                        </div>
                    </div>
                <?php } ?>
                <?php $p++; ?>
            </div>
        <?php endif;
        if ( $best_selling_products->have_posts() && ( $show_bestseller == 'show' ) ) :?>
            <div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="tab-bestseller">
                <?php if ( $show_hide_carousel == 'yes' ) { ?>
                    <div class="owl-carousel owl-theme producttab-carousel">
                        <?php if ( $best_selling_products->have_posts() ) :?>
                            <?php $row = 1;?>
                            <?php while ( $best_selling_products->have_posts() ) : $best_selling_products->the_post(); ?>
                                <?php if($row == 1) : ?>
                                    <div class="item-wrap">
                                <?php endif; ?>
                                    <div class="item <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php if( $row == (int) $atts['number_of_rows'] || $best_selling_products->current_post+1 == $best_selling_products->post_count) { $row=0; ?>
                                    </div>
                                <?php } $row++;?>
                            <?php endwhile; // end of the loop. ?>
                        <?php endif;
                        wp_reset_postdata();?>
                    </div>
                <?php } else { ?>
                    <div class="<?php echo implode(' ', $el_class2) ?>">
                        <div class="<?php echo implode(' ', $product_list); ?>">
                            <?php if ( $best_selling_products->have_posts() ) :?>
                                <?php while ( $best_selling_products->have_posts() ) : $best_selling_products->the_post(); ?>
                                    <div class="<?php echo implode(' ', $item_class2); ?> <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php endwhile; // end of the loop. ?>
                            <?php endif;
                            wp_reset_postdata();?>
                        </div>
                    </div>
                <?php } ?>
                <?php $p++; ?>
            </div>
        <?php endif; ?>

        <?php if ( $sale_products->have_posts() && ( $show_sale == 'show' ) ) :?>
            <div class="tab-pane fade<?php echo  $p == 0 ? ' in active': '' ?>" id="tab-onsale">
                <?php if ( $show_hide_carousel == 'yes' ) { ?>
                    <div class="owl-carousel owl-theme producttab-carousel">
                        <?php if ( $sale_products->have_posts() ) :?>
                            <?php $row = 1;?>
                            <?php while ( $sale_products->have_posts() ) : $sale_products->the_post(); ?>
                                <?php if($row == 1) : ?>
                                    <div class="item-wrap">
                                <?php endif; ?>
                                    <div class="item <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php if( $row == (int) $atts['number_of_rows'] || $sale_products->current_post+1 == $sale_products->post_count) { $row=0; ?>
                                    </div>
                                <?php } $row++;?>
                            <?php endwhile; // end of the loop. ?>
                        <?php endif;
                        wp_reset_postdata();?>
                    </div>
                <?php } else { ?>
                    <div class="<?php echo implode(' ', $el_class2) ?>">
                        <div class="<?php echo implode(' ', $product_list); ?>">
                            <?php if ( $sale_products->have_posts() ) :?>
                                <?php while ( $sale_products->have_posts() ) : $sale_products->the_post(); ?>
                                    <div class="<?php echo implode(' ', $item_class2); ?> <?php echo implode(' ', $item_class); ?>">
                                        <?php wc_get_template_part( 'content', 'product' ); ?>
                                    </div>
                                <?php endwhile; // end of the loop. ?>
                            <?php endif;
                            wp_reset_postdata();?>
                        </div>
                    </div>
                <?php } ?>
                <?php $p++; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script type="text/javascript">
	jQuery(document).ready(function($) {
	    var rtl = false;
    	if ($('body').hasClass('rtl')) rtl = true;

	    $('.producttab-carousel').owlCarousel({
	        responsive : {
                320 : {
	        		items: 1,
                    margin: 30
	        	},
				480 : {
	        		items: <?php if( (int) $items_mobile > 0) { echo esc_js($items_mobile); } else { echo '2'; } ?>,
                    margin: 30
	        	},
			    768 : {
			        items: <?php if( (int) $items_tablet > 0) { echo esc_js($items_tablet); } else { echo '2'; } ?>,
                    margin: 30
			    },
			    991 : {
			        items: <?php if( (int) $items_medium > 0) { echo esc_js($items_medium); } else { echo '3'; } ?>,
                    margin: 30
			    },
			    1199 : {
			        items: <?php if( (int) $items_show > 0) { echo esc_js($items_show); } else { echo '4'; } ?>,
			    }
			},
			rtl: rtl,
	        margin: <?php if( (int) $items_space > 0) { echo esc_js($items_space); } else { echo '30'; } ?>,
	        dots: <?php if( $show_pagination == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        nav: <?php if( $show_navigation == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplay: <?php if( $autoplay == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        loop: <?php if( $loop == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplayTimeout: <?php if( (int) $autoplaytimeout > 0 ) { echo esc_js($autoplaytimeout); } else { echo '5000'; } ?>,
	        smartSpeed: 1000,
			navText: ['<i class="icon-arrow prev"></i>','<i class="icon-arrow next"></i>']
	    });
	});
</script>
