<?php
/**
 * The template for displaying comments.
 *
 * @since   1.0.0
 * @package Erado
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div id="comments" class="comments-area mt_65">
	<?php if ( have_comments() ) : ?>
		<h4>
			<?php
				$comments_number = get_comments_number();
				if ( 1 === $comments_number ) {
					/* translators: %s: post title */
					printf( _x( 'Comment (1)', 'comments title', 'erado' ), get_the_title() );
				} else {
					printf(
						/* translators: 1: number of comments, 2: post title */
						_nx(
							'Comment (%1$s)',
							'Comments (%1$s)',
							$comments_number,
							'comments title',
							'erado'
						),
						number_format_i18n( $comments_number ),
						get_the_title()
					);
				}
			?>
		</h4>

		<?php the_comments_navigation(); ?>

		<ol class="commentlist">
			<?php
				wp_list_comments( array(
					'style'    => 'ol',
					'callback' => 'erado_comments_list',
				) );
			?>
		</ol><!-- .comment-list -->

		<?php the_comments_navigation(); ?>

	<?php endif; // Check for have_comments(). ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php echo esc_html__( 'Comments are closed.', 'erado' ); ?></p>
	<?php endif; ?>

	<?php
		$args = array(
			'comment_notes_before' => '',
            'fields' => '
				<div class="row mb_30">
					<div class="comment-form-author col-md-4">
						<input placeholder="' . esc_attr__( 'Your name *', 'erado' ) . '" type="text" required="required" size="30" value="" name="author" id="author">
					</div>
					<div class="comment-form-email col-md-4">
						<input placeholder="' . esc_attr__( 'Your email *', 'erado' ) . '" type="email" required="required" size="30" value="" name="email" id="email">
					</div>
					<div class="comment-form-url col-md-4">
						<input placeholder="' . esc_attr__( 'Your website', 'erado' ) . '" type="url" size="30" value="" name="url" id="url">
					</div>
				</div>
			',
			// Redefine your own textarea (the comment body)
			'comment_field' => '<div class="comment-form-comment mb_30"><textarea rows="8" placeholder="' . esc_attr__( 'Your comment *', 'erado' ) . '" name="comment" aria-required="true"></textarea></div>',

			// Change the title of the reply section
			'title_reply'=> esc_html__( 'Leave your comment', 'erado' ),

			// Change the title of send button
			'label_submit'=> esc_html__( 'Submit', 'erado' ),
		);

		comment_form( $args );
	?>
</div><!-- .comments-area -->
