<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<?php
$class_body_cart = '';
$cart_style = erado_get_option('wc-add-to-cart-style', 'default');

if( $cart_style == 'toggle-sidebar' ) {
	$class_body_cart = ' btn-sidebar';
} else {
	$class_body_cart = ' btn-cart-default';
}
?>

<body <?php body_class(); ?>>
	<?php if ( erado_get_option('site-loader', 1) == 1 ) erado_preloader(); ?>

	<?php if ( erado_get_option('show-toggle-sidebar', 1) ) : ?>
        <div class="toggle-sidebar-widget toggleSidebar">
            <div class="closetoggleSidebar"></div>
            <div class="widget-area">
                <?php dynamic_sidebar( 'toggle-sidebar' ); ?>
            </div>
        </div>
    <?php endif; ?>

	<?php
		$class_cart = '';
		//DEMO
		if ( isset( $_GET['ajax_cart'] ) && $_GET['ajax_cart'] !='' ) $cart_style = $_GET['ajax_cart'];

		if( $cart_style == 'toggle-sidebar' ) {
			$class_cart = 'toggleSidebar';
		}

		if ( class_exists( 'WooCommerce' ) && ($cart_style == 'toggle-sidebar') ) : ?>
		    <div class="<?php echo esc_attr($class_cart); ?> cartSidebarWrap">
				<div class="cart-sidebar-header-bottom">
					<span><?php esc_html_e('Shopping bag', 'erado'); ?><span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span></span>
				</div>
				<div class="cart-sidebar-header flex between-xs">
					<div class="cart-sidebar-title">
						<?php esc_html_e( 'Shopping Bag', 'erado' ); ?>
						<div class="cartContentsCount">
							<?php echo WC()->cart->cart_contents_count; ?>
						</div>
					</div>
					<span class="pe-7s-close close_cart_sidebar"></span>
				</div>
		        <div class="widget_shopping_cart_content"></div>
		    </div>
    	<?php endif; ?>

	<?php locate_template('views/menu-mobile.php', true);?>

	<div id="page" class="site oh">
		<?php erado_header(); ?>
