<?php
// Global variable which stores all meta boxes.
global $meta_boxes;
$meta_boxes   = array();

// 1st meta box
$meta_boxes[] = array(
    'id'         => 'custom_metabox',
    'title'      => esc_html__( 'Product Detail Options', 'erado' ),
    'post_types' => array( 'product' ),
    'autosave'   => true,
    'context'    => 'normal',
    'priority'   => 'high',
    'fields'     => array(
        array(
            'id'      => 'wc-single-style',
            'name'    => esc_html__( 'Product Detail Style', 'erado' ),
            'type'    => 'image_select',
            'radio'   => true,
            'options' => array(
                '1'   => get_template_directory_uri() . '/assets/images/layout/product-style-1.jpg',
                '2'   => get_template_directory_uri() . '/assets/images/layout/product-style-2.jpg',
                '3'   => get_template_directory_uri() . '/assets/images/layout/product-style-3.jpg',
                '4'   => get_template_directory_uri() . '/assets/images/layout/product-style-4.jpg',
                '5'   => get_template_directory_uri() . '/assets/images/layout/product-style-5.jpg',
                '6'   => get_template_directory_uri() . '/assets/images/layout/product-style-6.jpg',
            ),
            'std'     => '1',
        ),
        array(
            'id'          => 'wc-thumbnail-position',
            'name'        => esc_html__( 'Product Thumbnail Position', 'erado' ),
            'type'        => 'select',
            'radio'       => true,
            'options'     => array(
                'left'    => esc_html__( 'Left', 'erado' ),
                'right'   => esc_html__( 'Right', 'erado' ),
                'bottom'  => esc_html__( 'Bottom', 'erado' ),
                'outside' => esc_html__( 'Outside', 'erado' ),
            ),
            'std'         => 'bottom',
        ),
        array(
            'id'   => 'wc-single-video',
            'name' => esc_html__( 'Video', 'erado' ),
            'desc' => esc_html__( 'Support Vimeo & Youtube', 'erado' ),
            'type' => 'url',
            'std'  => ''
        )
    )
);
// TESTIMONIAL METABOX
//--------------------------------------------------
$meta_boxes[] = array(
	'title'      => esc_html__('Testimonial Informations', 'erado'),
	'id'         => 'testimonial_informations',
	'post_types' => array( 'testimonial' ),
	'context'    => 'normal',
	'priority'   => 'high',
	'fields'     => array(
		array(
			'name' => esc_html__( 'Enter Company Name', 'erado' ),
			'id'   => 'office',
			'type' => 'text',
			'desc' => esc_html__( 'Enter client company name.', 'erado' ),
		),
	),
);

// PORTFOLIO DESC
//--------------------------------------------------
$meta_boxes[] = array(
	'title'      => esc_html__('Portfolio Description', 'erado'),
	'id'         => 'portfolio-desc',
	'post_types' => array( 'portfolio' ),
	'context'    => 'normal',
	'priority'   => 'high',
	'fields'     => array(
		array(
			'name' => esc_html__( 'Description', 'erado' ),
			'id'   => 'portfolio-desc',
			'type' => 'textarea',
		),
	),
);

// Page Meta Box
$meta_boxes[] = array(
    'id'         => 'custom_metabox',
    'title'      => esc_html__( 'Page Layout', 'erado' ),
    'post_types' => array( 'page' ),
    'autosave'   => true,
    'context'    => 'normal',
    'priority'   => 'high',
    'fields'     => array(
        array(
            'id'          => 'show-page-title',
            'name'        => esc_html__( 'Show page title area', 'erado' ),
            'type'        => 'radio',
            'options'     => array(
                'show' => esc_html__( 'Show', 'erado' ),
                'hide' => esc_html__( 'Hide', 'erado' ),
            ),
            'required'    => true,
            'std'         => 'show',
        ),
        array(
            'id'        => 'page-layout',
            'name'      => esc_html__( 'Page Layout', 'erado' ),
            'type'      => 'image_select',
            'radio'     => true,
            'options'   => array(
                'left'  => ERADO_URL . '/assets/images/layout/left-sidebar.jpg',
                'no'    => ERADO_URL . '/assets/images/layout/no-sidebar.jpg',
                'right' => ERADO_URL . '/assets/images/layout/right-sidebar.jpg',
            ),
            'required' => true,
            'std'      => ''
        ),
    )
);

function erado_register_meta_boxes() {
	global $meta_boxes;
	if ( ! class_exists( 'RW_Meta_Box' ) )
		return;
	foreach ( $meta_boxes as $meta_box ) {
		new RW_Meta_Box( $meta_box );
	}
}
add_action( 'admin_init', 'erado_register_meta_boxes' );
