<?php
// Require the TGM_Plugin_Activation class.
include ERADO_PATH . '/inc/plugins/class-tgm-plugin-activation.php';

if ( ! function_exists( 'erado_register_required_plugins' ) ) {
    function erado_register_required_plugins() {
        $plugins = array(
			array(
	            'name'               => esc_html__('Erado Addons', 'erado'),
	            'slug'               => 'erado-addons',
	            'source'             => get_template_directory() . '/inc/plugins/erado-addons.zip',
                'image_url'          => get_template_directory_uri() . '/inc/plugins/images/jms_plugin.jpg',
	            'required'           => true,
                'version'            => '1.0',
	            'force_activation'   => false,
	            'force_deactivation' => false,
	            'external_url'       => '',
                'plg_func'           => 'erado_toolkit_load_textdomain',
                'plg_class'          => '',
	        ),
			array(
	            'name'               => esc_html__('Jms Image Swatch', 'erado'),
	            'slug'               => 'jms-imageswatch',
	            'source'             => get_template_directory() . '/inc/plugins/jms-imageswatch.zip',
                'image_url'          => get_template_directory_uri() . '/inc/plugins/images/jms_plugin.jpg',
	            'required'           => false,
                'version'            => '1.0',
	            'force_activation'   => false,
	            'force_deactivation' => false,
	            'external_url'       => '',
                'plg_func'           => 'jms_imageswatch_admin_menu',
                'plg_class'          => '',
	        ),
			array(
                'name'               => esc_html__('Revolution Slider', 'erado'),
                'slug'               => 'revslider',
                'source'             => get_template_directory() . '/inc/plugins/revslider.zip',
                'image_url'          => get_template_directory_uri() . '/inc/plugins/images/rev_slider.jpg',
                'required'           => true,
                'version'            => '5.4.8.1',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => '',
                'plg_class'          => 'RevSlider',
                'plg_func'           => '',
            ),
			array(
    			'name'           	 => esc_html__('Contact Form 7', 'erado'),
    			'slug'           	 => 'contact-form-7',
                'image_url'      	 => get_template_directory_uri() . '/inc/plugins/images/contact_form_7.jpg',
    			'required'       	 => true,
                'plg_class'       	 => 'WPCF7',
                'plg_func'       	 => '',
            ),
            array(
                'name'      		=> esc_html__('KC Pro', 'erado'),
                'slug'      		=> 'kc_pro',
    			'source'    		=> get_template_directory() . '/inc/plugins/kc_pro.zip',
                'image_url' 		=> get_template_directory_uri() . '/inc/plugins/images/kingcomposer.jpg',
                'required'  		=> true,
				'plg_class'       	 => 'kc_pro',
                'plg_func'       	 => '',
            ),
            array(
                'name'      		=> esc_html__('KingComposer', 'erado'),
                'slug'      		=> 'kingcomposer',
                'version'   		=> '2.7.7',
    			'source'    		=> get_template_directory() . '/inc/plugins/kingcomposer.zip',
                'image_url' 		=> get_template_directory_uri() . '/inc/plugins/images/kingcomposer.jpg',
                'required'  		=> true,
				'plg_class'       	 => 'KingComposer',
                'plg_func'       	 => '',
            ),
            array(
    			'name'           => esc_html__('MailChimp for WordPress', 'erado'),
    			'slug'           => 'mailchimp-for-wp',
                'image_url'      => get_template_directory_uri() . '/inc/plugins/images/mail-chimp.jpg',
    			'required'       => true,
                'plg_class'      => 'MC4WP_Admin',
                'plg_func'       => '',
    		),
            array(
                'name'      	 => esc_html__('Meta Box', 'erado'),
                'slug'      	 => 'meta-box',
    			'image_url' 	 => get_template_directory_uri() . '/inc/plugins/images/meta-box.jpg',
                'required'  	 => true,
				'plg_class'      => 'RWMB_Loader',
                'plg_func'       => '',
            ),
            array(
    			'name'      	 => esc_html__('Woocommerce', 'erado'),
    			'slug'      	 => 'woocommerce',
                'image_url' 	 => get_template_directory_uri() . '/inc/plugins/images/woocommerce.jpg',
    			'required'  	 => true,
				'plg_class'      => 'WooCommerce',
                'plg_func'       => '',
            ),
            array(
    			'name'      	 => esc_html__('YITH WooCommerce Popup', 'erado'),
    			'slug'      	 => 'yith-woocommerce-popup',
                'image_url' 	 => get_template_directory_uri() . '/inc/plugins/images/yith_popup.jpg',
    			'required'  	 => true,
				'plg_class'      => 'YITH_Popup',
                'plg_func'       => ''
    		),
            array(
    			'name'           => esc_html__('YITH WooCommerce Wishlist', 'erado'),
    			'slug'           => 'yith-woocommerce-wishlist',
                'image_url'      => get_template_directory_uri() . '/inc/plugins/images/yith_wishlist.jpg',
    			'required'       => true,
                'plg_class'      => 'YITH_WCWL',
                'plg_func'       => '',
    		),
            array(
    			'name'           => esc_html__('YITH WooCommerce Compare', 'erado'),
    			'slug'           => 'yith-woocommerce-compare',
                'image_url'      => get_template_directory_uri() . '/inc/plugins/images/yith_compare.jpg',
    			'required'       => true,
                'plg_class'      => 'YITH_WOOCOMPARE',
                'plg_func'       => '',
    		),
            array(
                'name'      	 => esc_html__( 'YITH WooCommerce Ajax Product Filter', 'erado' ),
                'slug'      	 => 'yith-woocommerce-ajax-navigation',
				'image_url' 	 => get_template_directory_uri() . '/inc/plugins/images/yith_filter.jpg',
                'required'  	 => true,
				'plg_class'      => 'YITH_WCAN',
                'plg_func'       => '',
            ),
    	);

        /*
    	 * Array of configuration settings. Amend each line as needed.
    	 *
    	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
    	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
    	 * sending in a pull-request with .po file(s) with the translations.
    	 *
    	 * Only uncomment the strings in the config array if you want to customize the strings.
    	 */
    	$config = array(
    		'id'           => 'tgmpa',
    		'menu'         => 'tgmpa-install-plugins',
    		'parent_slug'  => 'themes.php',
    		'capability'   => 'manage_options',
    		'has_notices'  => true,
    		'dismissable'  => true,
    		'is_automatic' => true,
    	);

        tgmpa( $plugins, $config );

    }
    add_action('tgmpa_register', 'erado_register_required_plugins');
}
