<?php
/*
* [ Add inline styles. ] - - - - - - - - - - - - - - - - - - - -
*/
if ( ! function_exists( 'erado_custom_css' ) ) {
    function erado_custom_css( $css = array() ) {
        if ( !class_exists ( 'ReduxFramework' ) ) return;

        // Body font
        $body_fonts = erado_get_option( 'body-font');
        $body_color = erado_get_option( 'body-color');

        if ( isset($body_fonts['font-family']) ) {
            $css[] = '
                body {
                    color: ' . esc_attr( $body_color ) . ';
                    font-family: ' . esc_attr( $body_fonts['font-family'] ) . ';
                    font-weight: ' . esc_attr( $body_fonts['font-weight'] ) . ';
                    font-size: ' . esc_attr( $body_fonts['font-size'] ).';
                    letter-spacing: ' . esc_attr( $body_fonts['letter-spacing'] ) . ';
                }
            ';
        }

        // Second font
        $second_fonts = erado_get_option( 'second-font');
        if ( isset($second_fonts['font-family']) && $second_fonts['font-family'] ) {
            $css[] = '
                .font-second, .product-box .box-action .price, .product-box .product-info .price, .entry-summary .erado-countdown > div span:first-child, .entry-summary .price, .modal_add_to_cart .product-info .price, .modal_add_to_cart p.total .woocommerce-Price-amount, .kc-countdown-timer .timer, .banner-box.banner4-5 .banner-text-4 p{
                    font-family: '.esc_attr( $second_fonts['font-family'] ).';
                }
            ';
        }

        // Third font
        $third_fonts = erado_get_option( 'third-font');

        if ( isset($third_fonts['font-family']) ) {
            $css[] = '
                .font-third, .addon-title p, 
                .banner-box .banner-text-2 p, 
                .banner-box.banner2-5 .banner-text-3 p, 
                #newletter-box2 .kc-col-container .newletter-des p {
                    font-family: ' . esc_attr( $third_fonts['font-family'] ) . ';
                    font-style: ' . esc_attr( $third_fonts['font-style'] ).';
                }
            ';
        }

        // Body font
        $body_fonts = erado_get_option( 'body-font');
        $body_color = erado_get_option( 'body-color');

        if ( isset($body_fonts['font-family']) ) {
            $css[] = '
                body {
                    color: ' . esc_attr( $body_color ) . ';
                    font-family: ' . esc_attr( $body_fonts['font-family'] ) . ';
                    font-weight: ' . esc_attr( $body_fonts['font-weight'] ) . ';
                    font-size: ' . esc_attr( $body_fonts['font-size'] ).';
                    letter-spacing: ' . esc_attr( $body_fonts['letter-spacing'] ) . ';
                }
                .color-body-color, body, .portfolio-filter > a, .product-box .product-info .product-cat a, 
                .single-product-thumbnail .slick-prev:before, .single-product-thumbnail .slick-next:before, 
                .fraction-slider .fs-pager-wrapper a.active, .fraction-slider .fs-pager-wrapper 
                a:hover, .fraction-slider .fs-custom-pager-wrapper a.active, .fraction-slider .fs-custom-pager-wrapper a:hover{
                        color: ' . esc_attr( $body_color ) . ';
                }
            ';
        }


        // Blog Background - Page Title
        $blog_bg = erado_get_option( 'blog-background' );

        if ( ! empty( $blog_bg['background-image'] ) ) {
            $css[] = '
                .blog .page-heading {
                    background-image: url(' . esc_url( $blog_bg['background-image'] ) . ');
                    background-size: ' . esc_attr( $blog_bg['background-size'] ) . ';
					background-repeat: ' . esc_attr( $blog_bg['background-repeat'] ) . ';
					background-position: ' . esc_attr( $blog_bg['background-position'] ) . ';
					background-attachment: ' . esc_attr( $blog_bg['background-attachment'] ) . ';
                }
            ';
        }

        if ( ! empty( $blog_bg['background-color'] ) ) {
            $css[] = '
                .blog .page-heading {
                    background-color: ' . esc_attr( $blog_bg['background-color'] ) . ';
                }
            ';
        }

        // Portfolio Background - Page Title
        $portfolio_bg = erado_get_option( 'portfolio-background' );

        if ( ! empty( $blog_bg['background-image'] ) ) {
            $css[] = '
                .post-type-archive-portfolio .page-heading {
                    background-image: url(' . esc_url( $portfolio_bg['background-image'] ) . ');
                    background-size: ' . esc_attr( $portfolio_bg['background-size'] ) . ';
					background-repeat: ' . esc_attr( $portfolio_bg['background-repeat'] ) . ';
					background-position: ' . esc_attr( $portfolio_bg['background-position'] ) . ';
					background-attachment: ' . esc_attr( $portfolio_bg['background-attachment'] ) . ';
                }
            ';
        }

        if ( ! empty( $portfolio_bg['background-color'] ) ) {
            $css[] = '
                .post-type-archive-portfolio .page-heading {
                    background-color: ' . esc_attr( $portfolio_bg['background-color'] ) . ';
                }
            ';
        }

        // Shop Background - Page Title
        $shop_bg = erado_get_option( 'wc-shop-background' );

        if ( ! empty( $shop_bg['background-image'] ) ) {
            $css[] = '
                .woocommerce-page .page-heading {
                    background-image: url(' . esc_url( $shop_bg['background-image'] ) . ');
                    background-size: ' . esc_attr( $shop_bg['background-size'] ) . ';
					background-repeat: ' . esc_attr( $shop_bg['background-repeat'] ) . ';
					background-position: ' . esc_attr( $shop_bg['background-position'] ) . ';
					background-attachment: ' . esc_attr( $shop_bg['background-attachment'] ) . ';
                }
            ';
        }

        if ( ! empty( $shop_bg['background-color'] ) ) {
            $css[] = '
                .woocommerce-page .page-heading {
                    background-color: ' . esc_attr( $shop_bg['background-color'] ) . ';
                }
            ';
        }

        // Maintenance Background
        $maintenance_bg = erado_get_option( 'maintenance-background' );

        if ( ! empty( $maintenance_bg['background-image'] ) ) {
            $css[] = '
                .maintenance-bg {
                    background-image: url(' . esc_url( $maintenance_bg['background-image'] ) . ');
                    background-size: ' . esc_attr( $maintenance_bg['background-size'] ) . ';
					background-repeat: ' . esc_attr( $maintenance_bg['background-repeat'] ) . ';
					background-position: ' . esc_attr( $maintenance_bg['background-position'] ) . ';
					background-attachment: ' . esc_attr( $maintenance_bg['background-attachment'] ) . ';
                }
            ';
        }

        // Color scheme
        $main_color = erado_get_option('primary-color');

        if ( ! empty( $main_color ) ) {
            $css[] = '
                .color-primary-color, a:hover, a:focus, a:active, .header-action .icon-menu:hover:before, #header-cart .shopbag:hover:before, .top-header a:hover, .top-header a:focus, .top-header.light a:hover, .top-header .dropdown-menu ul li a:hover, .header-3 .main-navigation .push-menu-btn:hover span, #header-wrapper.header-7 .header-action .header-block ul li a:hover, #header-wrapper.header-8 .header-action .header-block ul li a:hover, .menu-toggle .icon-menu:hover:before, .primary-menu > li.current_page_item > a, .primary-menu > li:hover > a, .primary-menu .dropdown-menu .column-heading:hover, .primary-menu li a:hover, .primary-menu li.current-menu-ancestor > a, .primary-menu li.current-menu-item > a, .vertical-menu .dropdown-menu .column-heading:hover, .vertical-menu li a:hover, #footer-wrapper .info-contact .address-info:before, #footer-wrapper .info-contact .phone-info:before, #footer-wrapper .info-contact .email-info:before, #footer-wrapper a:hover, #footer-wrapper p a, #footer-wrapper .footer-bottom .copyright a, .post-title a:hover, .post-meta > span a:hover, .read-more-section a:hover, #main-sidebar .widget ul li a:hover, .single-post .entry-content p a, .portfolio-content .portfolio-category a:hover, .single-portfolio .portfolio-meta a:hover, .related-portfolio .portfolio-info span > a:hover, .widget a:hover, .widget_ranged_price_filter .ranged-price-filter li.current, .widget_order_by_filter .order-by-filter li.current, .icon-search:hover:before, .woocommerce .widget_layered_nav .yith-wcan-list ul li.chosen a, .fl-shop-categories li.current-cat a, .fl-shop-categories li:hover a, .product-box .quick-view-list span, .product-box .btn-quickview-box span, .product-box .box-action .button:hover, .product-box .box-action .not-found .entry-content button:hover[type="submit"], .not-found .entry-content .product-box .box-action button:hover[type="submit"], .product-box .box-action .banner-box .content-button a:hover, .banner-box .content-button .product-box .box-action a:hover, .product-box .box-action .fraction-slider .fs_obj a.button-slider:hover, .fraction-slider .fs_obj .product-box .box-action a.button-slider:hover, .product-box .box-action #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input:hover[type="submit"], #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .product-box .box-action input:hover[type="submit"], .product-box .box-action #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input:hover[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .product-box .box-action input:hover[type="submit"], .product-box .box-action .kc_button.button_boxtext:hover, .product-box .box-action .box-coundown-parent .kc_button:hover, .box-coundown-parent .product-box .box-action .kc_button:hover, .product-box .box-action .box-coundown-parent2 .kc_button:hover, .box-coundown-parent2 .product-box .box-action .kc_button:hover, .product-box .box-action .box-coundown-parent3 .kc_button:hover, .box-coundown-parent3 .product-box .box-action .kc_button:hover, .product-box .box-action .compare-button a:hover:before, .product-box .box-action .yith-wcwl-add-to-wishlist a:hover:before, .product-box .box-action .yith-wcwl-wishlistaddedbrowse a:before, .product-box .box-action .yith-wcwl-wishlistexistsbrowse a:before, .product-box .box-action .yith-wcwl-wishlistaddedbrowse a span, .product-box .box-action .yith-wcwl-wishlistexistsbrowse a span, .product-box .style-2 .box-action-thumb li a:hover:before, .product-box .style-2 .box-action-thumb.yith-wcwl-wishlistaddedbrowse a:before, .product-box .style-2 .box-action-thumb.yith-wcwl-wishlistexistsbrowse a:before, .product-box .style-2 .box-action-thumb.yith-wcwl-wishlistaddedbrowse a span, .product-box .style-2 .box-action-thumb.yith-wcwl-wishlistexistsbrowse a span, .product-box .style-3 .box-action-thumb3 li a:hover:before, .product-box .style-4 .wishlist-style4 .yith-wcwl-add-to-wishlist a:hover:before, .product-box .style-4 .wishlist-style4 .yith-wcwl-wishlistaddedbrowse a:before, .product-box .style-4 .wishlist-style4 .yith-wcwl-wishlistexistsbrowse a:before, .product-box .style-4 .wishlist-style4 .yith-wcwl-wishlistaddedbrowse a span, .product-box .style-4 .wishlist-style4 .yith-wcwl-wishlistexistsbrowse a span, .product-box .style-4 .box-action-thumb4 .button:hover, .product-box .style-4 .box-action-thumb4 .not-found .entry-content button:hover[type="submit"], .not-found .entry-content .product-box .style-4 .box-action-thumb4 button:hover[type="submit"], .product-box .style-4 .box-action-thumb4 .banner-box .content-button a:hover, .banner-box .content-button .product-box .style-4 .box-action-thumb4 a:hover, .product-box .style-4 .box-action-thumb4 .fraction-slider .fs_obj a.button-slider:hover, .fraction-slider .fs_obj .product-box .style-4 .box-action-thumb4 a.button-slider:hover, .product-box .style-4 .box-action-thumb4 #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input:hover[type="submit"], #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .product-box .style-4 .box-action-thumb4 input:hover[type="submit"], .product-box .style-4 .box-action-thumb4 #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input:hover[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .product-box .style-4 .box-action-thumb4 input:hover[type="submit"], .product-box .style-4 .box-action-thumb4 .kc_button.button_boxtext:hover, .product-box .style-4 .box-action-thumb4 .box-coundown-parent .kc_button:hover, .box-coundown-parent .product-box .style-4 .box-action-thumb4 .kc_button:hover, .product-box .style-4 .box-action-thumb4 .box-coundown-parent2 .kc_button:hover, .box-coundown-parent2 .product-box .style-4 .box-action-thumb4 .kc_button:hover, .product-box .style-4 .box-action-thumb4 .box-coundown-parent3 .kc_button:hover, .box-coundown-parent3 .product-box .style-4 .box-action-thumb4 .kc_button:hover, .product-box .style-5 .box-action-thumb5 li a:hover:before, .product-box .style-5 .button:hover, .product-box .style-5 .not-found .entry-content button:hover[type="submit"], .not-found .entry-content .product-box .style-5 button:hover[type="submit"], .product-box .style-5 .banner-box .content-button a:hover, .banner-box .content-button .product-box .style-5 a:hover, .product-box .style-5 .fraction-slider .fs_obj a.button-slider:hover, .fraction-slider .fs_obj .product-box .style-5 a.button-slider:hover, .product-box .style-5 #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input:hover[type="submit"], #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .product-box .style-5 input:hover[type="submit"], .product-box .style-5 #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input:hover[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .product-box .style-5 input:hover[type="submit"], .product-box .style-5 .kc_button.button_boxtext:hover, .product-box .style-5 .box-coundown-parent .kc_button:hover, .box-coundown-parent .product-box .style-5 .kc_button:hover, .product-box .style-5 .box-coundown-parent2 .kc_button:hover, .box-coundown-parent2 .product-box .style-5 .kc_button:hover, .product-box .style-5 .box-coundown-parent3 .kc_button:hover, .box-coundown-parent3 .product-box .style-5 .kc_button:hover, .product-box .product-info .product-cat a:hover, .product-box .product-info .price, .erado-list .product-box .yith-wcwl-wishlistaddedbrowse a:before, .erado-list .product-box .yith-wcwl-wishlistexistsbrowse a:before, .erado-list .product-extra .yith-wcwl-add-to-wishlist a:hover, .erado-list .product-extra .yith-wcwl-add-to-wishlist a:hover:before, .erado-list .product-extra .compare.button:hover, .erado-list .product-extra .not-found .entry-content button.compare:hover[type="submit"], .not-found .entry-content .erado-list .product-extra button.compare:hover[type="submit"], .erado-list .product-extra .banner-box .content-button a.compare:hover, .banner-box .content-button .erado-list .product-extra a.compare:hover, .erado-list .product-extra .fraction-slider .fs_obj a.compare.button-slider:hover, .fraction-slider .fs_obj .erado-list .product-extra a.compare.button-slider:hover, .erado-list .product-extra #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare:hover[type="submit"], #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .erado-list .product-extra input.compare:hover[type="submit"], .erado-list .product-extra #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare:hover[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .erado-list .product-extra input.compare:hover[type="submit"], .erado-list .product-extra .compare.kc_button.button_boxtext:hover, .erado-list .product-extra .box-coundown-parent .compare.kc_button:hover, .box-coundown-parent .erado-list .product-extra .compare.kc_button:hover, .erado-list .product-extra .box-coundown-parent2 .compare.kc_button:hover, .box-coundown-parent2 .erado-list .product-extra .compare.kc_button:hover, .erado-list .product-extra .box-coundown-parent3 .compare.kc_button:hover, .box-coundown-parent3 .erado-list .product-extra .compare.kc_button:hover, .erado-list .product-extra .compare.button:hover:before, .erado-list .product-extra .not-found .entry-content button.compare[type="submit"]:hover:before, .not-found .entry-content .erado-list .product-extra button.compare[type="submit"]:hover:before, .erado-list .product-extra .banner-box .content-button a.compare:hover:before, .banner-box .content-button .erado-list .product-extra a.compare:hover:before, .erado-list .product-extra .fraction-slider .fs_obj a.compare.button-slider:hover:before, .fraction-slider .fs_obj .erado-list .product-extra a.compare.button-slider:hover:before, .erado-list .product-extra #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare[type="submit"]:hover:before, #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .erado-list .product-extra input.compare[type="submit"]:hover:before, .erado-list .product-extra #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare[type="submit"]:hover:before, #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .erado-list .product-extra input.compare[type="submit"]:hover:before, .erado-list .product-extra .compare.kc_button.button_boxtext:hover:before, .erado-list .product-extra .box-coundown-parent .compare.kc_button:hover:before, .box-coundown-parent .erado-list .product-extra .compare.kc_button:hover:before, .erado-list .product-extra .box-coundown-parent2 .compare.kc_button:hover:before, .box-coundown-parent2 .erado-list .product-extra .compare.kc_button:hover:before, .erado-list .product-extra .box-coundown-parent3 .compare.kc_button:hover:before, .box-coundown-parent3 .erado-list .product-extra .compare.kc_button:hover:before, .erado-list .product-extra .compare.button.added, .erado-list .product-extra .not-found .entry-content button.compare.added[type="submit"], .not-found .entry-content .erado-list .product-extra button.compare.added[type="submit"], .erado-list .product-extra .banner-box .content-button a.compare.added, .banner-box .content-button .erado-list .product-extra a.compare.added, .erado-list .product-extra .fraction-slider .fs_obj a.compare.added.button-slider, .fraction-slider .fs_obj .erado-list .product-extra a.compare.added.button-slider, .erado-list .product-extra #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare.added[type="submit"], #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .erado-list .product-extra input.compare.added[type="submit"], .erado-list .product-extra #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare.added[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .erado-list .product-extra input.compare.added[type="submit"], .erado-list .product-extra .compare.added.kc_button.button_boxtext, .erado-list .product-extra .box-coundown-parent .compare.added.kc_button, .box-coundown-parent .erado-list .product-extra .compare.added.kc_button, .erado-list .product-extra .box-coundown-parent2 .compare.added.kc_button, .box-coundown-parent2 .erado-list .product-extra .compare.added.kc_button, .erado-list .product-extra .box-coundown-parent3 .compare.added.kc_button, .box-coundown-parent3 .erado-list .product-extra .compare.added.kc_button, .woocommerce-product-rating .woocommerce-review-link:hover, .entry-summary .price, .entry-summary .compare.button:hover, .entry-summary .not-found .entry-content button.compare:hover[type="submit"], .not-found .entry-content .entry-summary button.compare:hover[type="submit"], .entry-summary .banner-box .content-button a.compare:hover, .banner-box .content-button .entry-summary a.compare:hover, .entry-summary .fraction-slider .fs_obj a.compare.button-slider:hover, .fraction-slider .fs_obj .entry-summary a.compare.button-slider:hover, .entry-summary #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare:hover[type="submit"], #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .entry-summary input.compare:hover[type="submit"], .entry-summary #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare:hover[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .entry-summary input.compare:hover[type="submit"], .entry-summary .compare.kc_button.button_boxtext:hover, .entry-summary .box-coundown-parent .compare.kc_button:hover, .box-coundown-parent .entry-summary .compare.kc_button:hover, .entry-summary .box-coundown-parent2 .compare.kc_button:hover, .box-coundown-parent2 .entry-summary .compare.kc_button:hover, .entry-summary .box-coundown-parent3 .compare.kc_button:hover, .box-coundown-parent3 .entry-summary .compare.kc_button:hover, .entry-summary .compare.button:hover:before, .entry-summary .not-found .entry-content button.compare[type="submit"]:hover:before, .not-found .entry-content .entry-summary button.compare[type="submit"]:hover:before, .entry-summary .banner-box .content-button a.compare:hover:before, .banner-box .content-button .entry-summary a.compare:hover:before, .entry-summary .fraction-slider .fs_obj a.compare.button-slider:hover:before, .fraction-slider .fs_obj .entry-summary a.compare.button-slider:hover:before, .entry-summary #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare[type="submit"]:hover:before, #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .entry-summary input.compare[type="submit"]:hover:before, .entry-summary #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare[type="submit"]:hover:before, #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .entry-summary input.compare[type="submit"]:hover:before, .entry-summary .compare.kc_button.button_boxtext:hover:before, .entry-summary .box-coundown-parent .compare.kc_button:hover:before, .box-coundown-parent .entry-summary .compare.kc_button:hover:before, .entry-summary .box-coundown-parent2 .compare.kc_button:hover:before, .box-coundown-parent2 .entry-summary .compare.kc_button:hover:before, .entry-summary .box-coundown-parent3 .compare.kc_button:hover:before, .box-coundown-parent3 .entry-summary .compare.kc_button:hover:before, .entry-summary .compare.button.added, .entry-summary .not-found .entry-content button.compare.added[type="submit"], .not-found .entry-content .entry-summary button.compare.added[type="submit"], .entry-summary .banner-box .content-button a.compare.added, .banner-box .content-button .entry-summary a.compare.added, .entry-summary .fraction-slider .fs_obj a.compare.added.button-slider, .fraction-slider .fs_obj .entry-summary a.compare.added.button-slider, .entry-summary #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare.added[type="submit"], #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .entry-summary input.compare.added[type="submit"], .entry-summary #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input.compare.added[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields .entry-summary input.compare.added[type="submit"], .entry-summary .compare.added.kc_button.button_boxtext, .entry-summary .box-coundown-parent .compare.added.kc_button, .box-coundown-parent .entry-summary .compare.added.kc_button, .entry-summary .box-coundown-parent2 .compare.added.kc_button, .box-coundown-parent2 .entry-summary .compare.added.kc_button, .entry-summary .box-coundown-parent3 .compare.added.kc_button, .box-coundown-parent3 .entry-summary .compare.added.kc_button, .entry-summary .yith-wcwl-add-to-wishlist a:hover, .entry-summary .yith-wcwl-add-to-wishlist a:hover:before, .product_meta a:hover, .woocommerce-tabs .wc-tabs > li.active > a, .title_style_1:before, .banner-box.banner2-5 .banner-text-2 p strong, .banner-box.banner4-1 strong, .banner-box.banner4-2 strong, .banner-box.banner4-4 .banner-text-3 p, .banner-box.banner4-3 .banner-text-3 p, .banner-box.banner4-5 .banner-text-4 p, #jmsblog-box .post-meta li a:hover, #jmsblog-box.template-2 .read-more a:hover, .tab-product.nav-tabs > li:hover > a, .tab-product.nav-tabs > li.active > a, .category-tab li.current-cat a, .kc_tabs_custom.kc_tabs .kc_wrapper .kc_tabs_nav > li:hover, .kc_tabs_custom.kc_tabs .kc_wrapper .kc_tabs_nav > li:hover a, .kc_tabs_custom.kc_tabs .kc_wrapper .kc_tabs_nav > li.ui-tabs-active, .kc_tabs_custom.kc_tabs .kc_wrapper .kc_tabs_nav > li.ui-tabs-active:hover, .kc_tabs_custom.kc_tabs .kc_wrapper .kc_tabs_nav > li.ui-tabs-active > a, .kc_tabs_custom.kc_tabs .kc_wrapper .kc_tabs_nav > li.ui-tabs-active > a:hover, .kc_tabs_custom.kc_tabs .kc_tab.ui-tabs-body-active .kc_tab_content .kc-col-inner-container h5, .breadcrumb a:hover, .woocommerce-breadcrumb a:hover
                {
                    color: ' . esc_attr( $main_color ) . ';
                }
            ';

            $css[] = '
                .background-primary-color,
                .button, 
                .kc_tabs_custom.kc_tabs .kc_tab.ui-tabs-body-active .kc_tab_content .kc-col-inner-container a.kc_button,
                #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"], 
                #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"], 
                body .kc_button, input[type="button"], input[type="reset"], input[type="submit"], .btn-transparent:hover, 
                .btn-transparent:focus, 
                .owl-theme .owl-dots .owl-dot.active span, 
                .owl-theme .owl-dots .owl-dot:hover span, #header-cart .cart-count, 
                .post-category a:hover, 
                .page-links a:hover, 
                .page-links > span:not(.page-links-title), 
                .pagination-block .page-numbers li span:hover, 
                .pagination-block .page-numbers li a:hover, 
                .pagination-block .page-numbers li .current, 
                .tagcloud a:hover, .tagcloud a:focus, 
                .widget_price_filter .ui-slider .ui-slider-range, 
                .widget_shopping_cart_content .buttons a:hover, 
                .woocommerce .widget_layered_nav ul.yith-wcan-label li a:hover,
                .woocommerce-page .widget_layered_nav ul.yith-wcan-label li a:hover, 
                .woocommerce .widget_layered_nav ul.yith-wcan-label li a:focus, 
                .woocommerce-page .widget_layered_nav ul.yith-wcan-label li a:focus, 
                .woocommerce .widget_layered_nav ul.yith-wcan-label li.chosen a, 
                .woocommerce-page .widget_layered_nav ul.yith-wcan-label li.chosen a, 
                .wc-notice-cart .icon-notice, .shop-filter .filter-title, .badge, 
                .product-box .btn-quickview-box span:hover, 
                .product-box .box-action .add-to-cart a,
                nav.woocommerce-pagination ul li a:focus, 
                nav.woocommerce-pagination ul li a:hover, 
                nav.woocommerce-pagination ul li span.current, 
                .wc-single-video a:hover, 
                .woocommerce-tabs .wc-tabs > li.active:after, 
                .cartSidebarWrap.toggleBottom .cart-sidebar-header-bottom, 
                .cartSidebarWrap .cart-sidebar-header .cartContentsCount, .title_style_1:after, 
                .banner-box .content-button a, 
                .banner-position .banner-box-translate .banner-box .content .content-button a, 
                #jmstestimonial-box.template-2 .owl-theme .owl-dots .owl-dot.active span, 
                .fraction-slider .fs_obj a, 
                .fraction-slider .fs-pager-wrapper a:before, 
                .fraction-slider .fs-custom-pager-wrapper a:before, 
                .newsletter-box1 .newsletter-form button:hover, 
                .box-coundown-parent3 .box-coundown .box-coundown-content .title2_coundown:before, 
                .jmsfeatured_category .item.style-2:hover .category-info, 
                .spinner1 .bounce1, .spinner1 .bounce2 {
                    background-color: ' . esc_attr( $main_color ) . ';
                }
            ';

            $css[] = '
                .border-primary-color,
                input[type="text"]:focus,
                input[type="number"]:focus,
                input[type="tel"]:focus,
                input[type="email"]:focus,
                input[type="url"]:focus,
                input[type="password"]:focus,
                input[type="search"]:focus, textarea:focus,
                .btn-transparent:hover, .btn-transparent:focus,
                .post-category a:hover, .page-links a:hover,
                .page-links > span:not(.page-links-title), 
                .tagcloud a:hover, .tagcloud a:focus, 
                .woocommerce .widget_layered_nav ul.yith-wcan-label li a:hover, 
                .woocommerce-page .widget_layered_nav ul.yith-wcan-label li a:hover, 
                .woocommerce .widget_layered_nav ul.yith-wcan-label li a:focus, 
                .woocommerce-page .widget_layered_nav ul.yith-wcan-label li a:focus, 
                .woocommerce .widget_layered_nav ul.yith-wcan-label li.chosen a, 
                .woocommerce-page .widget_layered_nav ul.yith-wcan-label li.chosen a, 
                .wc-notice-cart .text-notice a,
                .fraction-slider .fs-pager-wrapper a.active, 
                .fraction-slider .fs-pager-wrapper a:hover, 
                .fraction-slider .fs-custom-pager-wrapper a.active, 
                .fraction-slider .fs-custom-pager-wrapper a:hover,
                .loadmore-button a {
                    border-color: ' . esc_attr( $main_color ) . ';
                }
            ';
        }
        $main_color_dark = erado_get_option('primary-color-dark');
        if ( ! empty( $main_color_dark) ) {
            $css[] = '
                .erado-list .product-extra .add-to-cart a:hover,
                .button:hover, .banner-box .content-button a:hover, .banner-position .banner-box-translate .banner-box .content .content-button a:hover, .fraction-slider .fs_obj a.button-slider:hover, #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"]:hover, #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"]:hover, .kc_button.button_boxtext:hover, .box-coundown-parent .kc_button:hover, .box-coundown-parent2 .kc_button:hover, .box-coundown-parent3 .kc_button:hover, .button:focus, .banner-box .content-button a:focus, .banner-position .banner-box-translate .banner-box .content .content-button a:focus, .fraction-slider .fs_obj a.button-slider:focus, #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"]:focus, #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"]:focus, .kc_button.button_boxtext:focus, .box-coundown-parent .kc_button:focus, .box-coundown-parent2 .kc_button:focus, .box-coundown-parent3 .kc_button:focus, input[type="button"]:hover, input[type="button"]:focus, input[type="reset"]:hover, input[type="reset"]:focus, input[type="submit"]:hover, input[type="submit"]:focus{
                    background: ' . esc_attr( $main_color_dark ) . ';
                }
                .boder-color-darken, .button, .banner-box .content-button a, .banner-position .banner-box-translate .banner-box .content .content-button a, .fraction-slider .fs_obj a.button-slider, #footer-wrapper .newletter-footer-top .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"], #footer-wrapper .newletter-footer .widget_mc4wp_form_widget .mc4wp-form .mc4wp-form-fields input[type="submit"], .kc_button.button_boxtext, .box-coundown-parent .kc_button, .box-coundown-parent2 .kc_button, .box-coundown-parent3 .kc_button, input[type="button"], input[type="reset"], input[type="submit"], .product-box .box-action .add-to-cart a, .product-box .style-5 .add-to-cart a{
                    border-color: ' . esc_attr( $main_color_dark ) . ';
                }
            ';
        }
        // menu font
        $menu_font = erado_get_option( 'menu-font');
        if ( ! empty( $menu_font['font-family'] ) || ! empty( $menu_font['font-weight'] ) || ! empty( $menu_font['font-size'] ) ) {
            $css[] = '
                .primary-menu > li > a,
                .vertical-menu > li > a {
                    font-family: '. esc_attr( $menu_font['font-family'] ) .';
                    font-weight: '. esc_attr( $menu_font['font-weight'] ) .';
                    font-size: '. esc_attr( $menu_font['font-size'] ) .';
                }
            ';
        }

        // heading font & color
        $heading_font  = erado_get_option( 'heading-font', '600' );
        $heading_color = erado_get_option( 'heading-color', '#0e0e0e' );
		//print_r($heading_font['font-family']); exit;
		if ( isset($heading_font['font-family']) && $heading_font['font-family'] ) {
			$css[] = '
                h1, h2, h3, h4, h5, h6 {
                    font-family: '.  $heading_font['font-family'].';                    
                }
            ';	
		}
		if ( isset($heading_font['font-weight']) && $heading_font['font-weight'] ) {
			$css[] = '
                h1, h2, h3, h4, h5, h6 {
                    font-weight: '. esc_attr( $heading_font['font-weight'] ) .';                    
                }
            ';	
		}
		if ( isset($heading_color) && $heading_color ) {
			$css[] = '
                h1, h2, h3, h4, h5, h6 {
                    color: '. esc_attr( $heading_color ) .';                    
                }
            ';	
		}

        $h1_size = erado_get_option( 'h1-font-size', '36' );
        $h2_size = erado_get_option( 'h2-font-size', '30' );
        $h3_size = erado_get_option( 'h3-font-size', '24' );
        $h4_size = erado_get_option( 'h4-font-size', '21' );
        $h5_size = erado_get_option( 'h5-font-size', '18' );
        $h6_size = erado_get_option( 'h6-font-size', '16' );

        if (isset($h1_size['font-size']) && $h1_size ) {
            $css[] = '
                h1 { font-size:' . esc_attr( $h1_size['font-size'] ) . '; }
            ';
        }

        if (isset($h2_size['font-size']) && $h2_size ) {
            $css[] = '
                h2 { font-size:' . esc_attr( $h2_size['font-size'] ) . '; }
            ';
        }

        if (isset($h3_size['font-size']) && $h3_size ) {
            $css[] = '
                h3 { font-size:' . esc_attr( $h3_size['font-size'] ) . '; }
            ';
        }

        if (isset($h4_size['font-size']) && $h4_size ) {
            $css[] = '
                h4 { font-size:' . esc_attr( $h4_size['font-size'] ) . '; }
            ';
        }

        if (isset($h5_size['font-size']) && $h5_size ) {
            $css[] = '
                h5 { font-size:' . esc_attr( $h5_size['font-size'] ) . '; }
            ';
        }

        if (isset($h6_size['font-size']) && $h6_size ) {
            $css[] = '
                h6 { font-size:' . esc_attr( $h6_size['font-size'] ) . '; }
            ';
        }

        // Topbar
        $topbar_bg = erado_get_option('topbar-background');
        if ( ! empty( $topbar_bg ) ) {
            $css[] = '
                .top-header {
                    background-color: ' . esc_attr( $topbar_bg ) . ';
                }
            ';
        }

        $topBarBorder = erado_get_option('topbar-border');
        if ( ! empty( $topBarBorder ) ) {
            $css[] = '
                .border-topbar-color, 
                .top-header, 
                .topheader-left .header-block, 
                .topheader-right .header-block{
                    border-color: ' . esc_attr( $topBarBorder ) . ';
                }
            ';
        }

        // Header
        $header_bg = erado_get_option( 'header-background' );
        if ( ! empty( $header_bg ) ) {
            $css[] = '
                #header-wrapper .main-header {
                    background-color: '. esc_attr( $header_bg ) .';
                }
            ';
        }

        $header_action_icon_color = erado_get_option('header-icon-style', 'inherit');
        if ( !empty( $header_action_icon_color ) && $header_action_icon_color == 'white' ) {
            $css[] = '
                #header-wrapper .header-action .dropdown-toggle {
                    color: #ffffff;
                }
            ';
        }

        $header_border = erado_get_option( 'header-border' );
        if ( ! empty( $header_border ) ) {
            $css[] = '
                #header-wrapper .main-header {
                    border-color: '. esc_attr( $header_border ) .';
                }
            ';
        }

        $header_color = erado_get_option( 'header-color' );
        if ( ! empty( $header_color ) ) {
            $css[] = '
                #header-wrapper,
                #header-wrapper .primary-menu > li > a,
                .header-5 .vertical-menu > li > a {
                    color: '. esc_attr( $header_color ) .';
                }
            ';
        }
        // Footer
        $footer_bg = erado_get_option( 'footer-background' );
        if ( ! empty( $footer_bg['background-image'] ) ) {
            $css[] = '
                #footer-wrapper {
                    background-image: url(' . esc_url( $footer_bg['background-image'] ) . ');
                    background-size: ' . esc_attr( $footer_bg['background-size'] ) . ';
					background-repeat: ' . esc_attr( $footer_bg['background-repeat'] ) . ';
					background-position: ' . esc_attr( $footer_bg['background-position'] ) . ';
					background-attachment: ' . esc_attr( $footer_bg['background-attachment'] ) . ';
                }
            ';
        }

        if ( ! empty( $footer_bg['background-color'] ) ) {
            $css[] = '
                #footer-wrapper {
                    background-color: '. esc_attr( $footer_bg['background-color'] ) .';
                }
            ';
        }

        $footer_border = erado_get_option( 'footer-border' );
        if ( ! empty( $footer_border ) ) {
            $css[] = '
                #footer-wrapper .container .footer-bottom,
                #footer-wrapper .container-fluid .footer-bottom {
                    border-color: '. esc_attr( $footer_border ) .';
                }
            ';
        }

        $footer_widget_title_color = erado_get_option( 'widget-title-color' );
        if ( ! empty( $footer_widget_title_color ) ) {
            $css[] = '
                #footer-wrapper .footer-top .widget .widget-title h3,
                #footer-wrapper .newletter-footer .title-newletter{
                    color: '. esc_attr( $footer_widget_title_color ) .';
                }
            ';
        }

        $footer_color = erado_get_option( 'footer-color' );
        if ( ! empty( $footer_color ) ) {
            $css[] = '
                #footer-wrapper,
                #footer-wrapper a {
                    color: '. esc_attr( $footer_color ) .';
                }
            ';
        }
        

        // Single background
        $single_product_bg = erado_get_option( 'wc-single-product-background' );
        if ( !empty( $single_product_bg ) ) {
            $css[] = '
                .wc-product-detail-layout-2 .product-detail-bg {
                    background-color: '. esc_attr( $single_product_bg ) .';
                }
            ';
        }

        /////////////////////////Demo Css 

        // Demo bg topbar
        if ( isset($_GET['topbar_bg']) && $_GET['topbar_bg'] == 'fe4108' ) {

            $css[] = '
                .top-header,
                .top-header a {
                    color: #fff;
                }
                .top-header a:hover,
                .top-header a:focus{
                    color: #000;
                }
            ';
            $css[] = '
                .topheader-left .header-block,
                .topheader-right .header-block {
                    border-color: #fe8c69;
                }
            ';

            $css[] = '
                .top-header{
                    background-color: #f04108;
                    border: 0;
                }
            ';
        } elseif ( isset($_GET['topbar_bg']) && $_GET['topbar_bg'] == 'fff' ) {
            $css[] = '
                .top-header,
                .top-header a {
                    color: #111;
                }
            ';
            $css[] = '
                .topheader-left .header-block{ border-right: 2px solid #f5f5f5; }
                .topheader-right .header-block{ border-left: 2px solid #f5f5f5; }
            ';

            $css[] = '
                .top-header{
                    background-color: #fff;
                    border-bottom: 2px solid #f5f5f5;
                }
            ';
        }elseif ( isset($_GET['topbar_bg'])) {

            $css[] = '
                .top-header,
                .top-header a {
                    color: #C5C5C5;
                }
            ';
            $css[] = '
                .topheader-left .header-block,
                .topheader-right .header-block {
                    border-color: #2e2e2e;
                }
            ';

            $css[] = '
                .top-header{
                    background-color: #'. $_GET['topbar_bg'] .';
                    border: 0;
                }
            ';
        }

        // Demo header
        if ( isset( $_GET['header_bg'] ) ) {
            $css[] = '
                #header-wrapper .main-header {
                    background-color: #'. $_GET['header_bg'] .';
                }
            ';
        }

        if ( isset( $_GET['header_color'] ) ) {
            $css[] = '
                #header-wrapper,
                #header-wrapper .primary-menu > li > a,
                .header-5 .vertical-menu > li > a {
                    color: #'. $_GET['header_color'] .';
                }
            ';
        }
        $layout = erado_get_option( 'header-layout', 1 );
         if ( isset($_GET['header']) && $_GET['header'] == '9' ) {
            $css[] = '
                #header-wrapper.fixed-top .primary-menu > li > a,
                .fixed-top .top-header a,
                .fixed-top .top-header{
                    color: #000;
                }
                #header-wrapper .primary-menu > li > a,
                .top-header a,
                .top-header{
                    color: #fff;
                }
            ';
         }
         if ( isset($_GET['header']) && $_GET['header'] == '8' ) {
            $css[] = '
                #header-wrapper.fixed-top .primary-menu > li > a,
                .fixed-top .top-header a,
                .fixed-top .top-header,
                .fixed-top .header-action.white .dropdown-toggle{
                    color: #000;
                }
                #header-wrapper .primary-menu > li > a,
                .top-header a,
                .top-header{
                    color: #fff;
                }
            ';
         }

        // Demo bg footer
        if ( isset( $_GET['footer_bg'] ) ) {
            $css[] = '
                #footer-wrapper {
                    background-color: #'. $_GET['footer_bg'] .';
                }
            ';

            $css[] = '
                #footer-wrapper .container .footer-bottom ,
                #footer-wrapper .container-fluid .footer-bottom{
                    border-color: #111;
                }
            ';

            $css[] = '
                #footer-wrapper .footer-top .widget .widget-title h3,
                #footer-wrapper .newletter-footer .title-newletter{
                    color: #ffffff;
                }
            ';

            $css[] = '
                #footer-wrapper,
                #footer-wrapper a,
                #footer-wrapper a:hover,
                #footer-wrapper p a,
                #footer-wrapper .footer-bottom .footer-block .widget-title h3{
                    color: #bfbfbf;
                }
                #footer-wrapper .footer-bottom .copyright a{
                    color: ' . esc_attr( $main_color ) . ';
                }
                #footer-wrapper .info-contact .des-info,
                #footer-wrapper .info-contact .address-info,
                #footer-wrapper .info-contact .phone-info,
                #footer-wrapper .info-contact .email-info,
                #footer-wrapper .info-contact .phone-info a,
                #footer-wrapper .info-contact .email-info a{
                    color: #bfbfbf;
                }
                #footer-wrapper .footer-bottom .copyright{
                color: #6e6e6e;
            }
            ';
        }
        if ( isset( $_GET['footer_bg_image'] ) && $_GET['footer_bg_image'] == '1' ) {
            $css[] = '
                #footer-wrapper {
                    background-image: url('. ERADO_URL . '/assets/images/bg-bg.jpg'  .');
                    background-size: inherit;
                    background-repeat: no-repeat;
                    background-position: center center;
                    background-attachment: scroll;
                }
            ';

            $css[] = '
                #footer-wrapper .container .footer-bottom ,
                #footer-wrapper .container-fluid .footer-bottom {
                    border-top: 2px solid #111;
                }
            ';

            $css[] = '
                #footer-wrapper .footer-top .widget .widget-title h3,
                #footer-wrapper .newletter-footer .title-newletter {
                    color: #ffffff;
                }
            ';

            $css[] = '
                #footer-wrapper,
                #footer-wrapper a,
                #footer-wrapper a:hover,
                #footer-wrapper p a,
                #footer-wrapper .footer-bottom .copyright a,
                #footer-wrapper .footer-bottom .footer-block .widget-title h3{
                    color: #C5C5C5;
                }
            ';
        }

        return preg_replace( '/\n|\t/i', '', implode( '', $css ) );
    }
}
