<?php
if ( ! function_exists ('erado_post_thumbnail')  ) {
    function erado_post_thumbnail() {
        if ( has_post_thumbnail() ) {
            ?>
            <div class="post-thumbnail mb_25">
                <a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark" title="<?php the_title(); ?>">
                    <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
                </a>
            </div>
            <?php
        }
    }
}
// **********************************************************************//
// ! Get exceprt from post content
// **********************************************************************//

if( ! function_exists( 'erado_excerpt_from_content' ) ) {
	function erado_excerpt_from_content($post_content, $limit, $shortcodes = '') {
		// Strip shortcodes and HTML tags
		if ( empty( $shortcodes )) {
			$post_content = preg_replace("/\[caption(.*)\[\/caption\]/i", '', $post_content);
			$post_content = preg_replace('`\[[^\]]*\]`','',$post_content);
		}

		$post_content = stripslashes( wp_filter_nohtml_kses( $post_content ) );

		if ( erado_get_option( 'blog-words-or-letters' ) == 'letter' ) {
			$excerpt = mb_substr( $post_content, 0, $limit );
			if ( mb_strlen( $excerpt ) >= $limit ) {
				$excerpt .= '...';
			}
		} else{
			$limit++;
			$excerpt = explode(' ', $post_content, $limit);
			if ( count( $excerpt) >= $limit ) {
				array_pop( $excerpt );
				$excerpt = implode( " ", $excerpt ) . '...';
			} else {
				$excerpt = implode( " ", $excerpt );
			}
		}

		$excerpt = strip_tags( $excerpt );

		if ( trim( $excerpt ) == '...' ) {
			return '';
		}

		return $excerpt;
	}
}

/**
 * Prints post title.
 *
 * @return string
 */
if ( ! function_exists( 'erado_post_title' ) ) {
	function erado_post_title() {
		$output = '';

		if ( !is_single() ) {
			$output .= sprintf( '<h2 class="post-title entry-title mb_7"><a class="chp" href="%2$s" rel="bookmark">%1$s</a></h2>', get_the_title(), esc_url( get_permalink() ) );
		} else {
			$output .= sprintf( '<h1 class="post-title entry-title">%s</h1>', get_the_title() );
		}

		echo apply_filters( 'erado_post_title', $output );
	}
}

/**
 * Prints post meta with the post author, categories and post comments.
 *
 * @return string
 */
if ( ! function_exists( 'erado_post_meta' ) ) {
	function erado_post_meta() {
		$output = '';
		// Post author
		$output .= sprintf(
			esc_html__( '%1$s', 'erado' ),
			'<span class="author">'. esc_html__('By', 'erado') .' <a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'

		);

		$time = '<span class="time updated"><a href="' . esc_url( get_permalink() ) . '">%2$s</a></span>';
		$output .= sprintf( $time,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() )
		);

		// Post comments
		if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			$comment_number = get_comments_number();
			if($comment_number == 1){
				$output .= sprintf( '<span class="comment-number"><a href="%2$s">' . esc_html__( '%1$s Comment', get_comments_number(), 'erado' ) . '</a></span>', number_format_i18n( get_comments_number() ), get_comments_link() );
			}else{
				$output .= sprintf( '<span class="comment-number"><a href="%2$s">' . esc_html__( '%1$s Comments', get_comments_number(), 'erado' ) . '</a></span>', number_format_i18n( get_comments_number() ), get_comments_link() );
			}
		}

		echo apply_filters( 'erado_post_meta', '<div class="post-meta">' . $output . '</div>' );
	}
}


/**
 * Custom function to use to open and display each comment
 *
 * @since 1.0.0
 */
if ( ! function_exists( 'erado_comments_list' ) ) {
	function erado_comments_list( $comment, $args, $depth ) {
	// Globalize comment object
		$GLOBALS['comment'] = $comment;

		switch ( $comment->comment_type ) :

			case 'pingback'  :
			case 'trackback' :
				?>
				<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
					<p>
						<?php
							echo esc_html__( 'Pingback:', 'erado' );
							comment_author_link();
							edit_comment_link( esc_html__( 'Edit', 'erado' ), '<span class="edit-link">', '</span>' );
						?>
					</p>
				<?php
			break;

			default :
				global $post;
				?>
				<li <?php comment_class( 'mb_60' ); ?> id="li-comment-<?php comment_ID(); ?>">
                    <article id="comment-<?php comment_ID(); ?>" class="comment_container">
                    	<?php echo get_avatar( $comment, 80 ); ?>

						<div class="comment-text">
							<?php if ( '0' == $comment->comment_approved ) : ?>
								<p class="comment-awaiting-moderation"><?php echo esc_html__( 'Your comment is awaiting moderation.', 'erado' ); ?></p>
							<?php endif; ?>

							<?php
								printf(
								'<h5 class="comment-author"><span>%1$s</span></h5>',
									get_comment_author_link(),
									( $comment->user_id == $post->post_author ) ? '<span class="author-post">' . esc_html__( 'Post author', 'erado' ) . '</span>' : ''
								);
							?>
							<div>
								<?php comment_text(); ?>
							</div>


							<div class="flex">
								<?php
									printf(
										'<time class="grow">%3$s</time>',
										esc_url( get_comment_link( $comment->comment_ID ) ),
										get_comment_time( 'c' ),
										sprintf( wp_kses_post( '%1$s at %2$s', 'erado' ), get_comment_date(), get_comment_time() )
									);
								?>
								<?php
									edit_comment_link( wp_kses_post( '<span>' . esc_html__( 'Edit', 'erado' ) . '</span>', 'erado' ) );
									comment_reply_link(
										array_merge(
											$args,
											array(
												'reply_text' => wp_kses_post( '<span class="ml__10">' . esc_html__( 'Reply', 'erado' ) . '</span>', 'erado' ),
												'depth'      => $depth,
												'max_depth'  => $args['max_depth'],
											)
										)
									);
								?>
							</div><!-- .action-link -->
						</div><!-- .comment-content -->
					</article><!-- #comment- -->
				<?php
			break;

		endswitch;
	}
}

/**
 * Display navigation to next/previous set of posts when applicable.
 *
 * @return string
 */
if ( ! function_exists( 'erado_post_pagination' ) ) {
	function erado_post_pagination( $nav_query = false ) {

		global $wp_query, $wp_rewrite;

		// Don't print empty markup if there's only one page.
		if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
			return;
		}

		// Prepare variables
		$query        = $nav_query ? $nav_query : $wp_query;
		$max          = $query->max_num_pages;
		$current_page = max( 1, get_query_var( 'paged' ) );
		$big          = 999999;
		?>
		<nav class="pagination-block tc">
			<?php
				echo '' . paginate_links(
					array(
						'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format'    => '?paged=%#%',
						'current'   => $current_page,
						'total'     => $max,
						'type'      => 'list',
						'prev_text' => '<i class="fa fa-angle-left"></i>',
						'next_text' => '<i class="fa fa-angle-right"></i>',
					)
				) . ' ';
			?>
		</nav><!-- .page-nav -->
		<?php
	}
}

/**
 * Render post tags.
 */
if ( ! function_exists( 'erado_post_tags' ) ) {
	function erado_post_tags() {
		$output = '';

		// Get the tag list
		$tags_list = get_the_tag_list( '', esc_html__( ', ', 'erado' ) );
        if ( !$tags_list ) return;
		$output .= sprintf( '<i class="pe-7s-ticket"></i> ' . esc_html__( '%1$s', 'erado' ), $tags_list );
        echo apply_filters( 'erado_post_tags', '<div class="post-tags mb_30">' . $output . '</div>' );
	}
}

/**
 * Next and previous article
 */

if ( ! function_exists('erado_post_navigation')) {
	function erado_post_navigation() {

		$html = '';

		$next_post = get_next_post();
		$prev_post = get_previous_post();

		if ( !empty($next_post) || !empty($prev_post) ) {

            if (!empty($prev_post)) {
	            $html .= '<div class="post-prev-post">';
	            $html .= '<div class="post-next-prev-content">';
	            $html .= '<a href="' . esc_url(get_permalink($prev_post->ID)) . '">' . get_the_title( $prev_post->ID ) . '<span class="db">' . esc_html__('Previous article', 'erado') . '</span></a>';
	            $html .= '</div>';
	            $html .= '</div>';
	        } else {
	            $html .= '<div class="post-prev-post">';
	            $html .= '</div>';
	        }

	        if (!empty($next_post)) {
	            $html .= '<div class="post-next-post tr">';
	            $html .= '<div class="post-next-prev-content">';
	            $html .= '<a href="' . esc_url(get_permalink($next_post->ID)) . '">' . get_the_title( $next_post->ID ) . '<span class="db">' . esc_html__('Next article', 'erado') . '</span></a>';
	            $html .= '</div>';
	            $html .= '</div>';
	        }

		}

        echo apply_filters( 'erado_post_navigation', '<div class="post-navigation flex between-xs mb_30 mt_50">' . $html . '</div>' );
	}
}

/**
 * Render related post based on post tags.
 */
if ( ! function_exists( 'erado_related_post' ) ) {
	function erado_related_post() {
		global $post;

		// Get post's tags
		$tags = wp_get_post_tags( $post->ID );

		if ( $tags ) {
			// Get id for all tags
			$tag_ids = array();

			foreach ( $tags as $tag ) {
				$tag_ids[] = $tag->term_id;
			}

			// Build arguments to query for related posts
			$args = array(
				'tag__in'             => $tag_ids,
				'post__not_in'        => array( $post->ID ),
				'posts_per_page'      => 5,
				'ignore_sticky_posts' => 1,
				'orderby'             => 'desc',
			);

			// Get related post
			$related = new wp_query( $args );

			$output = '';
			$output .= '<div class="post-related mt_85">';
                $output .= '<div class="addon-title mb_20">';
				$output .= '<h3>' . esc_html__( 'Related Articles', 'erado' ) . '</h3>';
                $output .= '</div>';
				$output .= '<div class="related-post-carousel owl-carousel owl-theme" data-carousel=\'{"selector":".related-post-carousel", "itemDesktop": 3, "itemMedium": 3, "itemTablet": 2, "itemMobile": 1, "margin":30 , "nav":true}\'>';
					while ( $related->have_posts() ) :
						// Update global post data
						$related->the_post();

						$output .= '<div class="item">';
							if ( has_post_thumbnail() ) {
								$output .= '<a class="db mb_15" href="' . esc_url( get_permalink() ) . '">';
									$img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

									if ( class_exists('Aq_Resize') && $img[1] >= 277 && $img[2] >= 197 ) {
									    $image = aq_resize( $img[0], 276, 196, true );
									    $output .= '<img src="' . esc_url( $image ) . '" width="276" height="196" alt="' . get_the_title() . '" />';
									} else {
										$output .= '<img src="' . esc_url( $img[0] ) . '" alt="' . get_the_title() . '" />';
									}
								$output .= '</a>';
							}
							$output .= '<h4 class="mg_0 post-title-link"><a href="' . esc_url( get_permalink() ) . '">' . get_the_title() . '</a></h4>';
                            $output .= '<a href="' . esc_url( get_permalink() ) . '" class="db date">' . get_the_date() . '</a>';
						$output .= '</div>';
					endwhile;
				$output .= '</div>';
			$output .= '</div>';

			// Reset global query object
			wp_reset_postdata();

			echo apply_filters( 'erado_related_post', $output );
		}
	}
}

/**
 *
 * Limit Post Excerpt Length
 *
 */
if ( ! function_exists('erado_post_excerpt') ) {
	function erado_post_excerpt( $limit ) {
	  	$excerpt = explode(' ', get_the_excerpt(), $limit);

	  	if ( count($excerpt) >= $limit ) {
	    	array_pop( $excerpt );
	    	$excerpt = implode(" ",$excerpt).'...';
	    	$output = '';
	    	$output .= '<div class="readmore"><a href="' . esc_url( get_permalink() ) . '>Readmore</a></div>';
	  	} else {
	    	$excerpt = implode(" ",$excerpt);
	    	$output = '';
	    	$output .= '<div class="readmore"><a href="' . esc_url( get_permalink() ) . '>Readmore</a></div>';
	  	}

	  	$excerpt = preg_replace('`[[^]]*]`','',$excerpt);

	  	echo esc_attr($excerpt);
	}
}

/**
 * Get post content
 *
 * @since 1.0.0
 */
if( ! function_exists( 'erado_get_content' ) ) {
	function erado_get_content( $btn = true ) {
		global $post;

        if ( ! empty( $post->post_excerpt ) ) {
            the_excerpt();
        } else {
	        $excerpt_length = apply_filters( 'erado_get_excerpt_length', erado_get_option( 'blog-excerpt-length', 100 ) );
	        echo erado_excerpt_from_content( $post->post_content, 100 );
        }

        if( $btn ) {
        	echo '<p class="read-more-section"><a class="btn-read-more more-link" href="' . get_permalink() . '">' . esc_html__('Read more ...', 'erado') . '</a></p>';
        }

	}
}