<?php
if ( !class_exists( 'WooCommerce' ) ) return;

function erado_add_to_cart_message() {

	if( ! (isset( $_REQUEST['product_id'] ) && (int) $_REQUEST['product_id'] > 0 ) )
		return;

	$titles 	= array();
	$product_id = (int) $_REQUEST['product_id'];

	if ( is_array( $product_id ) ) {
		foreach ( $product_id as $id ) {
			$titles[] = get_the_title( $id );
		}
	} else {
		$titles[] = get_the_title( $product_id );
	}

	$titles     = array_filter( $titles );
	$added_text = sprintf( _n( '<div><b>%s</b> has been added to your cart.</div>', '%s have been added to your cart.', sizeof( $titles ), 'erado' ), '"' . wc_format_list_of_items( $titles ) . '"' );
	$message    = sprintf( '%s <a href="%s" class="wc-forward db">%s</a>', wp_kses_post( $added_text ), esc_url( wc_get_page_permalink( 'cart' ) ), esc_html__( 'View Cart', 'erado' ) );
	$data       =  array( 'message' => apply_filters( 'wc_add_to_cart_message', $message, $product_id ) );

	wp_send_json( $data );

	exit();
}
add_action( 'wp_ajax_add_to_cart_message', 'erado_add_to_cart_message' );
add_action( 'wp_ajax_nopriv_add_to_cart_message', 'erado_add_to_cart_message' );

remove_action( 'woocommerce_before_single_product', 'wc_print_notices', 10 );
remove_action( 'woocommerce_before_shop_loop', 'wc_print_notices', 10 );

/**
 * Customize product quick view.
 */
function erado_wc_quickview() {
	if ( !class_exists( 'WooCommerce' ) ) return;
	// Get product from request.
	if ( isset( $_POST['product'] ) && (int) $_POST['product'] ) {
		global $post, $product, $woocommerce;

		$id      = ( int ) $_POST['product'];
		$post    = get_post( $id );
		$product = get_product( $id );

		if ( $product ) {
			// Get quickview template.
			include ERADO_PATH . '/woocommerce/content-quickview-product.php';
		}
	}

	exit;
}
add_action( 'wp_ajax_erado_quickview', 'erado_wc_quickview' );
add_action( 'wp_ajax_nopriv_erado_quickview', 'erado_wc_quickview' );

/**
 * Load product tab by category
 */
function erado_product_tab_by_category() {
	if ( !class_exists( 'WooCommerce' ) ) return;

	$cat_id      = $_POST['category'];
	$item_class  = $_POST['class'];
	$order       = $_POST['order'];
	$orderby     = $_POST['orderby'];
	$total_items = ( int ) $_POST['total_items'];

	$args = array(
		'post_type'           => 'product',
		'post_status'         => 'publish',
		'ignore_sticky_posts' => 1,
		'orderby'             => $orderby,
		'order'               => $order,
		'meta_query'          => WC()->query->get_meta_query(),
		'posts_per_page'      => $total_items,
		'tax_query' 		  => $tax_query
	);

	$tax_query = WC()->query->get_tax_query();

	if ( isset($cat_id) ) {
		$args['tax_query'] = array(
			'relation' => 'AND',
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'id',
                'terms'    => $cat_id
            )
		);
	}

    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

	if ( $products->have_posts() ) :
	 	while ( $products->have_posts() ) : $products->the_post(); ?>
    		<div class="<?php echo esc_attr( $item_class ); ?>">
                <?php wc_get_template_part( 'content', 'product' ); ?>
             </div>
		<?php endwhile; // end of the loop. ?>
	<?php endif;
	wp_reset_postdata();

	exit;
}
add_action( 'wp_ajax_get_product_by_category', 'erado_product_tab_by_category' );
add_action( 'wp_ajax_nopriv_get_product_by_category', 'erado_product_tab_by_category' );

function erado_before_shop_loop_product() {
	$class = '';
	if ( erado_get_option('show-attribute-variation', 1) == 0 ) {
		$class = ' no-attribute';
	}

	if ( isset($_GET['ajax_cart']) && ( $_GET['ajax_cart'] == 'no-ajax' ) ) {
		$class = ' no-ajax';
	}

	echo '<div class="product-box'. esc_attr( $class ) .'">';
}

function erado_after_shop_loop_product() {
	echo '</div>';
}

add_action( 'woocommerce_before_shop_loop_item', 'erado_before_shop_loop_product', 5 );
add_action( 'woocommerce_after_shop_loop_item', 'erado_after_shop_loop_product', 5 );


remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );

remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );


function erado_second_product_thumbnail() {
	global $product, $woocommerce, $id;

	$attachment_ids = $product->get_gallery_image_ids();
	$id =	get_post_thumbnail_id( $product->get_id() );

	if ( erado_get_option('wc-product-hover-style') == 'swap' ) {
		if ( count($attachment_ids) > 0 ) {
			$secondary_image_id = $attachment_ids['0'];
			echo wp_get_attachment_image( $secondary_image_id, 'shop_catalog', '', $attr = array( 'class' => 'secondary-image attachment-shop-catalog' ) );
		}
		else {
			echo wp_get_attachment_image( $id, 'shop_catalog', '', $attr = array( 'class' => 'secondary-image attachment-shop-catalog' ) );
		}
	}
}

add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 5);
add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 4);
add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 15);
add_action('woocommerce_before_shop_loop_item_title', 'erado_second_product_thumbnail', 15);
add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 20);

/**
 * Show the product title in the product loop.
 */
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
if ( ! function_exists( 'erado_woocommerce_template_loop_product_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function erado_woocommerce_template_loop_product_title() {
		echo get_the_title();
	}
}

add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 5 );
add_action( 'woocommerce_shop_loop_item_title', 'erado_woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 20 );

// Product Shop
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
add_action( 'erado_woocommerce_result_count', 'woocommerce_result_count', 5 );

if ( ! function_exists( 'erado_woocommerce_catalog_ordering' ) ) {
	function erado_woocommerce_catalog_ordering() {
		global $wp_query;

		if ( 1 === (int) $wp_query->found_posts || ! woocommerce_products_will_display() ) {
			return;
		}

		$orderby                 = isset( $_GET['orderby'] ) ? wc_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
		$show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
		$catalog_orderby_options = apply_filters( 'woocommerce_catalog_orderby', array(
			'menu_order' => __( 'Default sorting', 'erado' ),
			'popularity' => __( 'Popularity', 'erado' ),
			'rating'     => __( 'Average rating', 'erado' ),
			'date'       => __( 'Sort by newness', 'erado' ),
			'price'      => __( 'Price: low to high', 'erado' ),
			'price-desc' => __( 'Price: high to low', 'erado' ),
		) );

		if ( ! $show_default_orderby ) {
			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( 'no' === get_option( 'woocommerce_enable_review_rating' ) ) {
			unset( $catalog_orderby_options['rating'] );
		}

		wc_get_template( 'loop/orderby.php', array( 'catalog_orderby_options' => $catalog_orderby_options, 'orderby' => $orderby, 'show_default_orderby' => $show_default_orderby ) );
	}
}

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
function erado_sharing_product() { ?>
	<div class="addthis_inline_share_toolbox_abpr"></div>
	<?php
}
add_action( 'woocommerce_single_product_summary', 'erado_sharing_product', 50 );

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 7 );


/**
 * Change number of products displayed per page.
 */
function erado_change_product_per_page() {
	$number = erado_get_option( 'wc-number-per-page' );
	return $number;
}
add_filter( 'loop_shop_per_page', 'erado_change_product_per_page' );


/**
 * Header Account
 */
if ( ! function_exists( 'erado_my_account' ) ) {
	function erado_my_account() {
		if ( !class_exists( 'WooCommerce' ) ) return;

		$output = '';
		$output .= '<div class="btn-group compact-hidden">';
		if ( is_user_logged_in() ) {
			$output .= '<a href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '" class="dropdown-toggle" data-toggle="dropdown">' . esc_html__( 'My Account', 'erado' ) . '</a>';
		} else {
			$output .= '<a href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '" class="dropdown-toggle" data-toggle="dropdown">' . esc_html__( 'Login', 'erado' ) . '</a>';
		}
		$output .='<div class="dropdown-menu dropdown-account">';
			$output .= '<ul>';
				if ( is_user_logged_in() ) {
					$output .= '<li><a href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '">' . esc_html__( 'Dashboard', 'erado' ) . '</a></li>';
					$output .= '<li><a href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '">' . esc_html__( 'Order Tracking', 'erado' ) . '</a></li>';
					$output .= '<li><a href="' . esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) ) . '">' . esc_html__( 'Logout', 'erado' ) . '</a></li>';
				} else {
					$output .= '<li><a href="' . esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '">' . esc_html__( 'Login / Register', 'erado' ) . '</a></li>';
				}
			$output .= '</ul>';
		$output .= '</div>';
		$output .= '</div>';

		return apply_filters( 'erado_my_account', $output );
	}
}



/**
 * Remove product in wishlist.
 */
function erado_remove_product_wishlist() {
	if ( ! ( isset ( $_POST['product_id'] ) && isset( $_POST['_nonce'] ) && wp_verify_nonce( $_POST['_nonce'], 'bb_erado' ) ) ) {
		wp_send_json ( array(
			'status' => 'false',
			'notice' => __( 'Not validate.', 'erado' )
		));
	}

	$product_id = intval( $_POST['product_id'] );

	$user_id = get_current_user_id();

	if( $user_id ) {
		global $wpdb;
		$sql = "DELETE FROM {$wpdb->yith_wcwl_items} WHERE user_id = %d AND prod_id = %d";
		$sql_args = array(
			$user_id,
			$product_id
		);
		$wpdb->query( $wpdb->prepare( $sql, $sql_args ) );
	} else {
		$wishlist = yith_getcookie( 'yith_wcwl_products' );
		foreach( $wishlist as $key => $item ){
			if( $item['prod_id'] == $product_id ){
				unset( $wishlist[ $key ] );
			}
		}
		yith_setcookie( 'yith_wcwl_products', $wishlist );
	}
	$data = array(
		'status' => 'true',
	);

	wp_send_json( $data );

	die();
}
// Delete product in wishlish
add_action( 'wp_ajax_erado_remove_product_wishlist', 'erado_remove_product_wishlist' );
add_action( 'wp_ajax_nopriv_erado_remove_product_wishlist', 'erado_remove_product_wishlist' );

/**
 * Add product title to wishlist notice.
 */
function erado_add_title_to_wishlist() {
	$product_id = isset( $_POST['add_to_wishlist'] ) ? intval( $_POST['add_to_wishlist'] ) : 0;

	if( ! $product_id ) return;

	$product_title = get_the_title( $product_id );

	return sprintf( __( '<b>%s</b> has been added to your Wishlist', 'erado' ), $product_title );
}
add_filter( 'yith_wcwl_product_added_to_wishlist_message', 'erado_add_title_to_wishlist' );



/**
 * Currency Dropdown
 */

if ( ! function_exists( 'erado_currency' )  ) {
 	function erado_currency() {
		if ( !class_exists( 'WooCommerce' ) ) return;

 		$output = '';

 		$output .= '<div class="btn-group compact-hidden">';
 			$output .= '<a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">'. esc_html__( 'USD', 'erado' ) .'</a>';

			$output .= '<div class="dropdown-menu dropdown-currency">';
				$output .= '<ul>';
					$output .= '<li><a href="#">'. esc_html__( 'USD', 'erado' ) .'</a></li>';
					$output .= '<li><a href="#">'. esc_html__( 'Euro', 'erado' ) .'</a></li>';
				$output .= '</ul>';
			$output .= '</div>';

 		$output .= '</div>';

 		return apply_filters( 'erado_currency', $output );
 	}
}

/* 	Erado Wishlist
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_wishlist' ) ){
	function erado_wishlist(){
		if( function_exists( 'YITH_WCWL' ) ):
			$wishlist_url = YITH_WCWL()->get_wishlist_url(); ?>
			<div class="btn-group" id="header-wishlist">
	            <a href="<?php echo esc_url($wishlist_url);?>" class="dropdown-toggle">
	                <i class="icon-wishlist"></i>
	            </a>
	        </div>
		<?php endif;
	}
}


/* 	Header cart
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_header_cart' ) ) {
	function erado_header_cart(){

		if ( !class_exists( 'WooCommerce' ) ) return;

		global $woocommerce;
		//DEMO
		$cart_style =
		$cart_style = isset($_GET['ajax_cart']) ? $_GET['ajax_cart'] : erado_get_option('wc-add-to-cart-style');

    	?>
        <div class="btn-group <?php echo esc_attr($cart_style); ?>" id="header-cart">
            <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="dropdown-toggle cart-contents" data-toggle="dropdown">
                <i class="shopbag"></i>
                <samp class="cart-count pa"><?php echo esc_attr($woocommerce->cart->cart_contents_count);?></samp>
            </a>
            <div class="dropdown-menu shoppingcart-box">
				<div class="widget_shopping_cart_content"></div>
            </div>
        </div>
	<?php
	}
}

/**
 * Ensure cart contents update when products are added to the cart via AJAX.
 */
function erado_header_cart_fragment( $fragments ) {
	if ( !class_exists( 'WooCommerce' ) ) return;
	global $woocommerce;

	ob_start();
	?>
    <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="dropdown-toggle cart-contents" data-toggle="dropdown">
        <i class="shopbag"></i>
        <samp class="cart-count pa"><?php echo esc_attr($woocommerce->cart->cart_contents_count);?></samp>
    </a>
	<?php
	$fragments['a.cart-contents'] = ob_get_clean();

	return $fragments;

}
add_filter('woocommerce_add_to_cart_fragments', 'erado_header_cart_fragment');

/**
 * Load mini cart on header.
 */

function erado_render_load_mini_cart() {
	$output = '';

	ob_start();
		$args['list_class'] = '';
		wc_get_template( 'cart/mini-cart.php' );
	$output = ob_get_clean();

	$result = array(
		'message'    => WC()->session->get( 'wc_notices' ),
		'cart_total' => WC()->cart->cart_contents_count,
		'cart_html'  => $output
	);

	echo json_encode( $result );
	exit;
}
add_action( 'wp_ajax_load_mini_cart', 'erado_render_load_mini_cart' );
add_action( 'wp_ajax_nopriv_load_mini_cart', 'erado_render_load_mini_cart' );

if ( ! function_exists( 'erado_woocommerce_filter' ) ) {
	function erado_woocommerce_filter() {
		if ( !class_exists( 'WooCommerce' ) ) return;
		$class_action = '';
		$shop_view_mode 	= isset($_GET['wc-view-mode']) ? (int)$_GET['wc-view-mode'] : erado_get_option( 'wc-view-mode', 1 );
		$shop_filter 		= isset($_GET['wc-filter']) ? (int)$_GET['wc-filter'] : erado_get_option( 'wc-filter', 1 );
		$shop_filter_style  = isset($_GET['wc-filter-style']) ? $_GET['wc-filter-style'] : erado_get_option( 'wc-filter-style', 'filter-off-canvas' );
		$shop_ordering     	= isset($_GET['wc-ordering']) ? (int)$_GET['wc-ordering'] : erado_get_option( 'wc-ordering', 0 );
		$shop_cat_tab     	= isset($_GET['wc-category-tab']) ? (int)$_GET['wc-category-tab'] : erado_get_option( 'wc-category-tab', 0 );
		$shop_filter_ajax   = isset($_GET['wc-filter-ajax']) ? (int)$_GET['wc-filter-ajax'] : erado_get_option( 'wc-filter-ajax', 0 );
		$shop_layout   		= isset($_GET['sidebar']) ? $_GET['sidebar'] : erado_get_option( 'wc-shop-layout', 'no' );
		if( isset($shop_cat_tab) && $shop_cat_tab == 1 ) $class_action = ' with-category';

		if( (isset($shop_view_mode) && $shop_view_mode != 1 ) && (isset($shop_ordering) && $shop_ordering != 1 ) && ( isset($shop_filter) && $shop_filter != 1 ) && ( isset($shop_cat_tab) && $shop_cat_tab == 1 ) ) {
			$class_action = ' centered-categories';
		}

		?>

		<div class="shop-action">
			<div class="shop-action-inner flex between-xs pb_10 <?php echo esc_attr($class_action); ?>">
				<?php if( $shop_view_mode == 1 ) : ?>
					<div class="wc-switch clearfix hidden-xs">
						<span><?php echo esc_html__('View mode:', 'erado'); ?></span>
						<a href="javascript:void(0)" class="active view-grid" title="<?php esc_html_e( 'Grid', 'erado' ); ?>"><i class="icon-grid"></i></a>
						<a href="javascript:void(0)" class="view-list" title="<?php esc_html_e( 'List', 'erado' ); ?>"><i class="icon-list"></i></a>
					</div>
				<?php endif; ?>
				<div>
				<?php
					/**
					 * woocommerce_before_shop_loop hook
					 *
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */
					do_action( 'woocommerce_before_shop_loop' );
				?>
				</div>
				<?php if( (isset($shop_ordering) && $shop_ordering == 1) || (isset($shop_filter) && $shop_filter == 1) ) : ?>
					<div class="action-right">
						<?php if( isset($shop_ordering) && $shop_ordering == 1 ) : ?>
							<?php erado_woocommerce_catalog_ordering(); ?>
						<?php endif; ?>
						<?php if (( (is_active_sidebar( 'shop-page' ) && $shop_filter_style == 'filter-off-canvas') || ( is_active_sidebar( 'woocommerce-filter-sidebar' ) && $shop_filter_style == 'filter-top')) && ( isset($shop_filter) && $shop_filter == 1 && $shop_layout == 'no')) : ?>
							<div class="shop-filter-toggle<?php if(isset($shop_filter_style) && $shop_filter_style == 'filter-top' ) { echo ' filter-top'; } else { echo ' filter-off-canvas'; }; ?>">
								<span class="hamburger-box pr">
									<span class="hamburger-inner"></span>
								</span>
								<span class="filter-text"><?php esc_html_e( 'Filter', 'erado' ); ?></span>
							</div>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
			<?php if ( $shop_cat_tab == 1 && $shop_layout == 'no') : ?>
					<ul id="fl-shop-categories" class="fl-shop-categories">
                        <?php erado_category_menu(); ?>
                    </ul>
				<?php endif; ?>
			<input type="hidden" name="current_url" id="current_url" value="" />
			<?php if ( isset($shop_filter_style) && $shop_filter_style == 'filter-off-canvas' && $shop_layout == 'no') : ?>
				<div class="shop-filter">
					<div class="filter-title flex between-xs">
						<h2 class="dib"><?php esc_html_e('Filter', 'erado'); ?></h2>
						<span class="pe-7s-close dib close-filter"></span>
					</div>
					<?php if ( is_active_sidebar( 'shop-page' ) ) : ?>
					<div class="shop-filters filter-sidebar clearfix">
						<?php dynamic_sidebar( 'shop-page' ); ?>
					</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<?php if ( isset($shop_filter_style) && $shop_filter_style == 'filter-top' && $shop_layout == 'no') : ?>
				<div class="shop-filter-top">
					<?php if ( is_active_sidebar( 'woocommerce-filter-sidebar' ) ) : ?>
					<div class="shop-filters filter-top clearfix">
						<?php dynamic_sidebar( 'woocommerce-filter-sidebar' ); ?>
					</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'erado_taxonomy_archive_description' ) ) {
	/**
	 * Show an archive description on taxonomy archives.
	 *
	 * @subpackage	Archives
	 */
	function erado_taxonomy_archive_description() {
		if ( is_product_taxonomy() && 0 === absint( get_query_var( 'paged' ) ) ) {
			$description = wc_format_content( term_description() );
			if ( $description ) {
				echo '<div class="term-description container mt_25">' . $description . '</div>';
			}
		}
	}
}
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
add_action( 'woocommerce_archive_description', 'erado_taxonomy_archive_description', 10 );

if ( ! function_exists('erado_cart_remove_item') ) {
	function erado_cart_remove_item() {
	    $item_key = $_POST['item_key'];

        $removed = WC()->cart->remove_cart_item( $item_key ); // Note: WP 2.3 >

        if ( $removed ) {
           $data['status'] = '1';
           $data['cart_count'] = WC()->cart->get_cart_contents_count();
           $data['cart_subtotal'] = WC()->cart->get_cart_subtotal();
        } else {
            $data['status'] = '0';
        }

        echo json_encode( $data );

        exit;
	}
}
add_action( 'wp_ajax_cart_remove_item', 'erado_cart_remove_item' );
add_action( 'wp_ajax_nopriv_cart_remove_item', 'erado_cart_remove_item' );

add_action( 'erado_woocommerce_breadcrumb', 'woocommerce_breadcrumb', 10 );

/*
 *	Category menu: Create single category list HTML
 */
if ( ! function_exists( 'erado_category_menu_create_list' ) ) {
	function erado_category_menu_create_list( $category, $current_cat_id, $categories_menu_divider, $current_top_cat_id = null ) {
		$output = '<li class="cat-item-' . $category->term_id;

		// Is this the current category?
		if ( $current_cat_id == $category->term_id ) {
			$output .= ' current-cat';
		}
		// Is this the current top parent-category?
		else if ( $current_top_cat_id && $current_top_cat_id == $category->term_id ) {
			$output .= ' current-parent-cat';
		}

		$output .=  '">' . $categories_menu_divider . '<a href="' . esc_url( get_term_link( (int) $category->term_id, 'product_cat' ) ) . '">' . esc_attr( $category->name ) . '</a></li>';

		return $output;
	}
}

/*
 *	Product category menu
 */
if ( ! function_exists( 'erado_category_menu' ) ) {
	function erado_category_menu() {
		global $wp_query;

		$shop_cat_tab = erado_get_option( 'wc-category-tab', 0 );

		$current_cat_id = ( is_tax( 'product_cat' ) ) ? $wp_query->queried_object->term_id : '';
		$is_category = ( strlen( $current_cat_id ) > 0 ) ? true : false;
		$hide_empty = ( $shop_cat_tab == 1 ) ? true : false;

		erado_category_menu_output( $is_category, $current_cat_id, $hide_empty );
	}
}

/*
 *	Product category menu: Output
 */
if ( ! function_exists( 'erado_category_menu_output' ) ) {
	function erado_category_menu_output( $is_category, $current_cat_id, $hide_empty ) {
		global $wp_query;

		//$page_id = wc_get_page_id( 'shop' );
		$page_url = get_permalink( get_page_by_title( 'Shop' ) );
		$hide_sub = true;
		$current_top_cat_id = null;
		$all_categories_class = '';

		// Is this a category page?
		if ( $is_category ) {
			$hide_sub = false;

			// Get current category's top-parent id
			$current_cat_parents = get_ancestors( $current_cat_id, 'product_cat' );
			if ( ! empty( $current_cat_parents ) ) {
				$current_top_cat_id = end( $current_cat_parents ); // Get last item from array
			}

			// Get current category's direct children
			$current_cat_direct_children = get_terms( 'product_cat',
				array(
					'fields'       	=> 'ids',
					'parent'       	=> $current_cat_id,
					'hierarchical'	=> true,
					'hide_empty'   	=> $hide_empty
				)
			);
			$category_has_children = ( empty( $current_cat_direct_children ) ) ? false : true;
		} else {
			// No current category, set "All" as current (if not product tag archive or search)
			if ( ! is_product_tag() && ! isset( $_REQUEST['s'] ) ) {
				$all_categories_class = ' class="current-cat"';
			}
		}

		$output_cat = '<li' . $all_categories_class . '><a href="' . esc_url ( $page_url ) . '">' . esc_html__( 'All', 'erado' ) . '</a></li>';
		$output_sub_cat = '';
		$output_current_sub_cat = '';

		// Categories order
		$orderby = 'slug';
		$order = 'asc';

		$categories = get_categories( array(
			'type'			=> 'post',
			'orderby'		=> $orderby, // Note: 'name' sorts by product category "menu/sort order"
			'order'			=> $order,
			'hide_empty'	=> $hide_empty,
			'hierarchical'	=> 1,
			'taxonomy'		=> 'product_cat'
		) );

		// Categories menu divider
		$categories_menu_divider = apply_filters( 'erado_shop_categories_divider', '<span>|</span>' );

		foreach( $categories as $category ) {
			// Is this a sub-category?
			if ( $category->parent != '0' ) {
				// Should sub-categories be included?
				if ( $hide_sub ) {
					continue; // Skip to next loop item
				} else {
					if (
						$category->parent == $current_cat_id || // Include current sub-category's children
						! $category_has_children && $category->parent == $wp_query->queried_object->parent // Include categories with the same parent (if current sub-category doesn't have children)
					) {
						$output_sub_cat .= erado_category_menu_create_list( $category, $current_cat_id, $categories_menu_divider );
					} else if ($category->term_id == $current_cat_id ) { // Include current sub-category (save in a separate variable so it can be appended to the start of the category list)
						$output_current_sub_cat = erado_category_menu_create_list( $category, $current_cat_id, $categories_menu_divider );
					}
				}
			} else {
				$output_cat .= erado_category_menu_create_list( $category, $current_cat_id, $categories_menu_divider, $current_top_cat_id );
			}
		}

		if ( strlen( $output_sub_cat ) > 0 ) {
			$output_sub_cat = '<ul class="fl-shop-sub-categories">' . $output_current_sub_cat . $output_sub_cat . '</ul>';
		}

		$output = $output_cat . $output_sub_cat;

		echo ''.$output;
	}
}
//Redeclare woocommerce function- Show a shop page description on product archives.
if ( ! function_exists( 'woocommerce_product_archive_description' ) ) {
    function woocommerce_product_archive_description() {
		$shop_page_title = '';
		$shop_page_title = isset($_GET['wc-shop-heading']) ? $_GET['wc-shop-heading'] : erado_get_option('wc-shop-heading');
		if($shop_page_title == 'title_background')
			$shop_page_title = 'Shop';
		elseif($shop_page_title == 'slideshow')
			$shop_page_title = 'Shop - Slideshow';
		//echo esc_attr($shop_page_title); exit;
		if($shop_page_title == '') return;
	    if ( is_shop() ) {
			$shop_page = get_page_by_title( $shop_page_title );
		    if ( $shop_page ) {
			    $description = wc_format_content( $shop_page->post_content );
			    if ( $description) {
				    echo '<div class="page-description">' . $description . '</div>';
			    }
		    }
	    }
    }
}

/* 	Get Product info added in cart
/* --------------------------------------------------------------------- */
if( ! function_exists( 'erado_get_productinfo' ) ) {
	function erado_get_productinfo() {
		global $product, $woocommerce_loop, $road_opt;

		$productid = intval( $_POST['data']['pid'] );
		$product   = get_product( $productid );
		$quantity  = intval( $_POST['data']['quantity'] );
		?>
		<div class="col-md-6 col-sm-12 product-cart">
			<p class="title"><?php esc_html_e('Product is added to cart', 'erado');?></p>
			<div class="product-wrapper flex">
				<div class="product-image">
					<?php echo str_replace( array( 'http:', 'https:' ), '', $product->get_image() ); ?>
				</div>
				<div class="product-info">
					<h4><?php echo esc_html($product->get_title());?></h4>
					<p class="price"><?php echo ''.$product->get_price_html(); ?></p>
					<p class="quantity"><?php echo esc_html__('Quantity', 'erado') . ': ' . $quantity; ?></p>
				</div>
			</div>
		</div>
		<div class="col-md-6 col-sm-12 product-total">
			<p class="title"><?php echo wp_kses_data( sprintf( _n( 'There is %d item in your cart', 'There are %d items in your cart', WC()->cart->get_cart_contents_count(), 'erado' ), WC()->cart->get_cart_contents_count() ) );?></p>
			<div class="product-total-wrapper">
				<p class="total"><?php _e( 'Subtotal', 'erado' ); ?>: <?php echo WC()->cart->get_cart_subtotal(); ?></p>
				<div class="buttons">
					<a class="button" href="<?php echo get_permalink( wc_get_page_id( 'cart' ) );?>"><?php esc_html_e('View Cart', 'erado');?></a>
					<a class="button continue-shopping" href="#"><?php esc_html_e('Continue Shopping', 'erado');?></a>
				</div>
			</div>
		</div>
		<?php
		die();
	}
}
add_action( 'wp_ajax_get_productinfo', 'erado_get_productinfo' );
add_action( 'wp_ajax_nopriv_get_productinfo', 'erado_get_productinfo' );
add_action( 'erado_woocommerce_breadcrumb', 'woocommerce_breadcrumb', 10 );
