<?php
if ( !class_exists( 'WooCommerce' ) ) return;
$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );
extract( $atts );

$el_class[] = 'jmsfeatured_category';
$categories = explode(",", $category);
$category_products = array();
// Don't show carousel
if ( $show_hide_carousel == 'no' ){
    $el_class2[] = 'jmsproductlist';
}

if ( !empty($number_of_columns) ) {
    $el_class2[] = 'product-col-' . $number_of_columns;
}

// Magin wrapper
$product_list = array();
$product_list[] = 'product-list-wrapper';
if ( !empty($columns_gap) ) {
    $product_list[] = 'ml_-' . ceil($columns_gap / 2) . ' mr_-' . ceil($columns_gap / 2);
}

// Padding Item
$item_class = array();
$item_class2[] = 'item item-wrapper';
if ( !empty($columns_gap) ) {
    $item_class2[] = 'pl_' . ceil($columns_gap / 2) . ' pr_' . ceil($columns_gap / 2);
}
if ( isset($style_navigation) && $style_navigation == '2' ) {
    $el_class[] = 'big-arrow';
}
if ( (!empty($productbox_style) && $productbox_style == 2 ) && $columns_gap > 0 ) {
    $item_class2[] = 'mb_' . $columns_gap;
}

if ( isset($product_style) && $product_style == '2' ) {
    $item_class[] = 'style-2';
} else {
    $item_class[] = 'style-1';
}

foreach($categories as $category_id){
    $args = array(
        'tax_query'             => array(
            array(
                'taxonomy'      => 'product_cat',
                'field'         => 'term_id',
                'terms'         => $category_id,
            )
        )
    );
    $thumbnail_id = get_term_meta( $category_id, 'thumbnail_id', true );
    $thumbnail_id1 = get_term_meta( $category_id, 'thumbnail_id1', true );
    $image = wp_get_attachment_url( $thumbnail_id );
    $image1 = wp_get_attachment_url( $thumbnail_id1 );
    $term = get_term( $category_id, 'product_cat' );

    if ( ! empty ( $term ) && ! is_a( $term, 'WP_Error' ) ) {
        $product_number = $term->count;
    } else {
        $product_number = '';
    }

    $link_cates = get_category_link( $category_id );
    $category_products[] = array(
        'products' => new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts )),
        'category_name' => get_the_category_by_ID($category_id),
        'image' => $image,
        'image1' => $image1,
        'count_product'=> $product_number,
        'link_cate' => $link_cates,
    );
}
?>
<div class="<?php echo implode(' ', $el_class) ?>">
<?php if( isset( $title ) && ! empty( $title ) ) : ?>
    <div class="addon-title mb_40">
        <h3><?php echo esc_attr($title); ?></h3>
        <?php if( isset( $description_addon ) && ! empty( $description_addon ) ) : ?>
            <p class="description"><?php echo esc_attr($description_addon); ?></p>
        <?php endif; ?>
    </div>
<?php endif; ?>
<?php if ( $show_hide_carousel == 'yes' ) { ?>
    <div class="product-carousel-<?php echo intval($rd_number); ?> owl-carousel owl-theme">
        <?php $row = 1;?>
        <?php foreach($category_products as $category_product) { ?>
            <?php if($row == 1) : ?>
                <div class="item-wrap">
            <?php endif; ?>
            <div class="item mb_40 <?php echo implode(' ', $item_class); ?>">
                <div class="image_category">
                    <a href="<?php echo $category_product['link_cate']; ?>">
                        <?php if ( $show_thumb == '1' ) { ?>
                        <img alt="thumb1" src="<?php echo $category_product['image']; ?>" />
                        <?php }else{ ?>
                        <img alt="thumb1" src="<?php echo $category_product['image1']; ?>" />
                        <?php } ?>
                    </a>
                </div>
                <div class="category-info-box">
                    <div class="category-info">
                        <div class="category_name">
                            <a href="<?php echo $category_product['link_cate']; ?> ">
                                <?php echo $category_product['category_name']; ?>
                            </a>
                        </div>
                        <?php if ( $show_count == 'yes' ) { ?>
                            <p class="number-product"><?php echo $category_product['count_product'].' '.esc_html__( 'Product', 'erado' );?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php if( $row == (int) $atts['number_of_rows'] || $category_products->current_post+1 == $category_products->post_count) { $row=0; ?>
                        </div>
                    <?php } $row++;?>
        <?php } ?>
    </div>
<?php }else{ ?>
    <div class="<?php echo implode(' ', $el_class2) ?>">
        <div class="<?php echo implode(' ', $product_list); ?>">
            <?php foreach($category_products as $category_product) { ?>
                <div class="item-wrap <?php echo implode(' ', $item_class2); ?>">
                    <div class="item mb_40 <?php echo implode(' ', $item_class); ?>">
                        <div class="image_category">
                            <a href="<?php echo $category_product['link_cate']; ?>">
                                <img src="<?php echo $category_product['image1']; ?>" />
                            </a>
                        </div>
                        <div class="category-info-box">
                            <div class="category-info">
                                <div class="category_name">
                                    <a href="<?php echo $category_product['link_cate']; ?> ">
                                        <?php echo $category_product['category_name']; ?>
                                    </a>
                                </div>
                                <?php if ( $show_count == 'yes' ) { ?>
                                    <p class="number-product"><?php echo $category_product['count_product'].' '.esc_html__( 'Product', 'erado' );?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>
</div>


<script type="text/javascript">
    jQuery(document).ready(function($) {
        var owl_product = $('.product-carousel-<?php echo intval($rd_number); ?>');
        var rtl = false;
        if ($('body').hasClass('rtl')) rtl = true;

        owl_product.owlCarousel({
            responsive : {
                320 : {
                    items: 1,
                    margin: 30
                },
                480 : {
                    items: <?php if( (int) $items_mobile > 0) { echo esc_js($items_mobile); } else { echo '2'; } ?>,
                    margin: 30
                },
                768 : {
                    items: <?php if( (int) $items_tablet > 0) { echo esc_js($items_tablet); } else { echo '2'; } ?>,
                    margin: 30
                },
                991 : {
                    items: <?php if( (int) $items_medium > 0) { echo esc_js($items_medium); } else { echo '3'; } ?>,
                    margin: 30
                },
                1199 : {
                    items: <?php if( (int) $items_show > 0) { echo esc_js($items_show); } else { echo '4'; } ?>,
                }
            },
            rtl: rtl,
            margin: <?php if( (int) $items_space > 0) { echo esc_js($items_space); } else { echo '30'; } ?>,
            dots: <?php if( $show_pagination == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
            nav: <?php if( $show_navigation == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
            autoplay: <?php if( $autoplay == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
            loop: <?php if( $loop == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
            autoplayTimeout: <?php if( (int) $autoplaytimeout > 0 ) { echo esc_js($autoplaytimeout); } else { echo '5000'; } ?>,
            smartSpeed: 1000,
            navText: ['<i class="icon-arrow prev"></i>','<i class="icon-arrow next"></i>']
        });
    });
</script>
