<?php
if ( !class_exists( 'WooCommerce' ) ) return;

$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract( $atts );

if ( !empty($extra_class) ) {
    $el_class[] = $extra_class;
}

$el_class[] = 'jmsproduct-box';

$el_class[] = 'effect-product-'.$hover_image;

if ( isset($style_navigation) && $style_navigation == '2' ) {
    $el_class[] = 'big-arrow';
}


$meta_query   = WC()->query->get_meta_query();
$meta_query[] = array(
    'key'   => '_featured',
    'value' => 'yes'
);

// Global Query
$args = array(
    'post_type'				=> 'product',
    'post_status'			=> 'publish',
    'ignore_sticky_posts'	=> 1,
    'posts_per_page' 		=> $total_items,
);
$args['meta_query'] = WC()->query->get_meta_query();
$tax_query   		= WC()->query->get_tax_query();

//recent products
if( isset( $product_type ) && ( $product_type == 'recent-product' ) ) {
    $args['orderby'] 	= $orderby;
    $args['order'] 		= $order;
    $args['tax_query']	= $tax_query;

    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );
}

//featured products
if( isset( $product_type ) && ( $product_type == 'featured-product' ) ) {

    $tax_query[] = array(
        'taxonomy' => 'product_visibility',
        'field'    => 'name',
        'terms'    => 'featured',
        'operator' => 'IN',
    );

    $args['orderby'] 	= $orderby;
    $args['order'] 		= $order;
    $args['tax_query']	= $tax_query;
    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

}

//best selling
if( isset( $product_type ) && ( $product_type == 'best-seller-product' ) ):
    $args['meta_key'] 	= 'total_sales';
    $args['orderby'] 	= 'meta_value_num';
    $args['tax_query']	= $tax_query;

    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

endif;

//sale products
if( isset( $product_type ) && ( $product_type == 'sale-product' ) ):

    $product_ids_on_sale = wc_get_product_ids_on_sale();
    $args['orderby']     = $orderby;
    $args['order']       = $order;
    $args['tax_query']   = $tax_query;
    $args['post__in']    = array_merge( array( 0 ), $product_ids_on_sale );

    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

endif;


// Don't show carousel
if ( $show_hide_carousel == 'no' ){
    $el_class2[] = 'jmsproductlist';
}

if ( !empty($number_of_columns) ) {
    $el_class2[] = 'product-col-' . $number_of_columns;
}

// Magin wrapper
$product_list = array();
$product_list[] = 'product-list-wrapper';
if ( !empty($columns_gap) ) {
    $product_list[] = 'ml_-' . ceil($columns_gap / 2) . ' mr_-' . ceil($columns_gap / 2);
}
if ( $loadmore == 'yes' ){
    $product_list[] = 'loadmore';
}
// Padding Item
$item_class = array();
$item_class2[] = 'item item-wrapper';
if ( !empty($columns_gap) ) {
    $item_class2[] = 'pl_' . ceil($columns_gap / 2) . ' pr_' . ceil($columns_gap / 2);
}

if ( (!empty($productbox_style) && $productbox_style == 2 ) && $columns_gap > 0 ) {
    $item_class2[] = 'mb_' . $columns_gap;
}

if ( isset($product_style) && $product_style == '2' ) {
    $item_class[] = 'product-style-2';
} else {
    $item_class[] = 'product-style-1';
}

?>

<div class="<?php echo implode(' ', $el_class) ?>">
    <?php if( isset( $title ) && ! empty( $title ) ) : ?>
        <div class="addon-title mb_40">
            <h3><?php echo esc_attr($title); ?></h3>
            <?php if( isset( $description_addon ) && ! empty( $description_addon ) ) : ?>
                <p class="description"><?php echo esc_attr($description_addon); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php if ( $show_hide_carousel == 'yes' ) { ?>
    	<div class="product-carousel-<?php echo intval($rd_number); ?> owl-carousel owl-theme ">
    		<?php if ( $products->have_posts() ) :?>
    			<?php $row = 1;?>
    			<?php while ( $products->have_posts() ) : $products->the_post(); ?>
    				<?php if($row == 1) : ?>
    					<div class="item-wrap">
    				<?php endif; ?>
                        <div class="item <?php echo implode(' ', $item_class); ?>">
                            <?php wc_get_template_part( 'content', 'product' ); ?>
                        </div>
    				<?php if( $row == (int) $atts['number_of_rows'] || $products->current_post+1 == $products->post_count) { $row=0; ?>
    					</div>
    				<?php } $row++;?>
    			<?php endwhile; // end of the loop. ?>
    		<?php endif;
    		wp_reset_postdata();?>
    	</div>
    <?php } else { ?>
    <div class="<?php echo implode(' ', $el_class2) ?>">
        <div class="<?php echo implode(' ', $product_list); ?>">
            <?php if ( $loadmore == 'yes' ){ ?>
                <?php if ( $products->have_posts() ) :?>
                    <?php while ( $products->have_posts() ) : $products->the_post(); ?>
                        <div class="morebox <?php echo implode(' ', $item_class2); ?> <?php echo implode(' ', $item_class); ?>">
                            <?php wc_get_template_part( 'content', 'product' ); ?>
                        </div>
                    <?php endwhile; // end of the loop. ?>
                <?php endif;
                wp_reset_postdata();?>
                <div class="loadmore-button">
                    <a href="#" id="loadMore">Load More</a>
                </div>
            <?php }else{ ?>
                <?php if ( $products->have_posts() ) :?>
                    <?php while ( $products->have_posts() ) : $products->the_post(); ?>
                        <div class="<?php echo implode(' ', $item_class2); ?> <?php echo implode(' ', $item_class); ?>">
                            <?php wc_get_template_part( 'content', 'product' ); ?>
                        </div>
                    <?php endwhile; // end of the loop. ?>
                <?php endif;
                wp_reset_postdata();?>
            <?php }?>
        </div>
    </div>
    <?php } ?>
</div>
<script type="text/javascript">
	jQuery(document).ready(function($) {
	    var owl_product = $('.product-carousel-<?php echo intval($rd_number); ?>');
		var rtl = false;
    	if ($('body').hasClass('rtl')) rtl = true;

	    owl_product.owlCarousel({
            responsive : {
                320 : {
	        		items: 1,
                    margin: 30
	        	},
				480 : {
	        		items: <?php if( (int) $items_mobile > 0) { echo esc_js($items_mobile); } else { echo '2'; } ?>,
                    margin: 30
	        	},
			    768 : {
			        items: <?php if( (int) $items_tablet > 0) { echo esc_js($items_tablet); } else { echo '2'; } ?>,
                    margin: 30
			    },
			    991 : {
			        items: <?php if( (int) $items_medium > 0) { echo esc_js($items_medium); } else { echo '3'; } ?>,
                    margin: 30
			    },
			    1199 : {
			        items: <?php if( (int) $items_show > 0) { echo esc_js($items_show); } else { echo '4'; } ?>,
			    }
			},
			rtl: rtl,
	        margin: <?php if( (int) $items_space > 0) { echo esc_js($items_space); } else { echo '30'; } ?>,
	        dots: <?php if( $show_pagination == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        nav: <?php if( $show_navigation == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplay: <?php if( $autoplay == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        loop: <?php if( $loop == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplayTimeout: <?php if( (int) $autoplaytimeout > 0 ) { echo esc_js($autoplaytimeout); } else { echo '5000'; } ?>,
	        smartSpeed: 1000,
			navText: ['<i class="icon-arrow prev"></i>','<i class="icon-arrow next"></i>']
	    });
        $(".loadmore div.morebox").css("display", "none");
        $(".loadmore div.morebox").slice(0, 4).show();
        $("#loadMore").on('click', function (e) {
            e.preventDefault();
            $(".loadmore div.morebox:hidden").slice(0, 4).slideDown();
            if ($(".loadmore div.morebox:hidden").length == 0) {
                $("#load").fadeOut('slow');
            }
            $('html,body').animate({
                scrollTop: $(this).offset().top
            }, 1500);
        });
	});
</script>
