<?php
get_header();

$layout = $pagination_type = $blog_style = $content_class = $sidebar_class = $layout_classes = $class = $data = '';

// Get blog options
$layout          = erado_get_option( 'blog-layout', 'left' );
$blog_style      = erado_get_option( 'blog-style', 'list' );
$pagination_type = erado_get_option( 'blog-pagination-type', 'number-pagination' );

// DEMO
if ( isset( $_GET['sidebar'] ) && $_GET['sidebar'] != '' ) $layout = $_GET['sidebar'];
if ( isset( $_GET['style'] ) && $_GET['style'] != '' ) $blog_style = $_GET['style'];


if ( isset($_GET['pagination']) && ( $_GET['pagination'] == 'number' ) ) {
	$pagination_type = 'number-pagination';
} elseif( isset($_GET['pagination']) && ( $_GET['pagination'] == 'loadmore' ) ) {
	$pagination_type = 'load-more';
} elseif( isset($_GET['pagination']) && ( $_GET['pagination'] == 'infinite' ) ) {
	$pagination_type = 'infinite-scroll';
}

// Render columns number
if ( $layout == 'left' ) {
	$content_class = 'col-lg-9 col-md-9 col-sm-8 col-xs-12 with-sidebar';
	$sidebar_class = 'col-lg-3 col-md-3 col-sm-4 col-xs-12';
	$layout_classes = 'left-sidebar';
} elseif ( $layout == 'right' ) {
	$content_class = 'col-lg-9 col-md-9 col-sm-8 col-xs-12 with-sidebar';
	$sidebar_class = 'col-lg-3 col-md-3 col-sm-4 col-xs-12';
	$layout_classes = 'right-sidebar';
} elseif ( $layout == 'no' ) {
	$content_class = 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
	$sidebar_class = '';
}

// Layout fitRows for pagination is loadmore
if ( ($blog_style == 'grid' && $pagination_type == 'load-more') || $blog_style == 'grid' && $pagination_type == 'infinite-scroll' ) {
	$class = 'erado-masonry';
	$data  = 'data-masonry=\'{"selector":".item","layoutMode":"fitRows"}\'';
} elseif( $blog_style == 'grid' ) {
    $class = 'erado-grid';
} elseif ($blog_style == 'list') {
	$class = 'erado-list';
} elseif ($blog_style == 'masonry') {
	$class = 'erado-masonry';
	$data  = 'data-masonry=\'{"selector":".item","layoutMode":"masonry","columnWidth":".item"}\'';
}

?>

<div class="fl-page-content">
	<?php get_template_part( 'views/page-heading/style', 1 ); ?>
	<div class="container mt_85 mb_75">
		<div class="fl-row row <?php echo esc_attr($layout_classes); ?>">
			<div id="main-content" class="<?php echo esc_attr( $content_class ); ?>">
				<div class="blog-layout row <?php echo esc_attr( $class ); ?>" <?php echo wp_kses_post( $data ); ?>>
					<?php
						if ( have_posts() ) :
							while ( have_posts() ) : the_post();
								if ( $blog_style == 'grid' ) {
									get_template_part( 'views/post/content', 'grid' );
								} elseif ( $blog_style == 'masonry' ) {
									get_template_part( 'views/post/content', 'masonry' );
								} else {
									get_template_part( 'views/post/content', get_post_format() );
								}
							endwhile;
						else :
							get_template_part( 'views/post/content', 'none' );
						endif;
					?>
				</div>
				<div class="clearfix"></div>
				<?php if ( 'load-more' == $pagination_type || 'infinite-scroll' == $pagination_type ) : ?>
					<div class="fl-ajax-load-more tc" data-load-more='{"page":"<?php echo esc_attr( $wp_query->max_num_pages ); ?>","container":"blog-layout","layout":"<?php echo esc_attr( $pagination_type ); ?>"}'>
						<?php echo next_posts_link( esc_html__( 'Load More', 'erado' ) ); ?>
					</div>
				<?php else : ?>
					<?php erado_post_pagination(); ?>
				<?php endif; ?>
			</div>

			<?php if ( isset( $layout ) && $layout != 'no' ) { ?>
				<div id="main-sidebar" class="<?php echo esc_attr( $sidebar_class ); ?>">
					<?php
						if ( is_active_sidebar( 'primary-sidebar' ) ) {
							dynamic_sidebar( 'primary-sidebar' );
						}
					?>
				</div>
			<?php } ?>
		</div>

	</div>
</div><!-- fl-page-content -->

<?php get_footer();
