<?php
$maintenance_title     = erado_get_option( 'maintenance-title' );
$maintenance_message   = erado_get_option( 'maintenance-message' );
$maintenance_countdown = erado_get_option( 'maintenance-countdown', 0 );
$maintenance_date      = erado_get_option( 'maintenance-date' );
$maintenance_month     = erado_get_option( 'maintenance-month' );
$maintenance_year      = erado_get_option( 'maintenance-year' );
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta http-equiv="Content-Type" content="text/html"/>
    	<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
        <div id="page" class="site oh">
            <div class="fl-page-content">
                <div class="maintenance-bg tc flex middle-xs center-xs">
                    <div class="inner container">
                        <?php if ( ! empty( $maintenance_title ) ): ?>
                            <h1><?php echo esc_attr( $maintenance_title ); ?></h1>
                        <?php endif; ?>
                        <?php if ( ! empty( $maintenance_message ) ): ?>
                            <p><?php echo esc_attr( $maintenance_message ); ?></p>
                        <?php endif; ?>

						<?php if ( $maintenance_countdown ): ?>
							<div class="erado-countdown" data-time='{"day": "<?php echo esc_attr( $maintenance_date ); ?>", "month": "<?php echo esc_attr( $maintenance_month ); ?>", "year": "<?php echo esc_attr( $maintenance_year ); ?>"}'></div>
						<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
		<?php wp_footer(); ?>
	</body>
</html>
