<?php
get_header();

$layout = $content_class = $sidebar_class = $layout_classes = '';

// Get page options
$layout = get_post_meta( get_the_ID(), 'page-layout', true );

if ( isset( $layout ) && $layout != 'no' ) {
	$content_class = 'col-lg-9 col-md-9 col-sm-8 col-xs-12 mt_75 mb_75';
	$sidebar_class = 'col-lg-3 col-md-3 col-sm-4 col-xs-12 mt_75 mb_75';
} else {
	$content_class = 'col-lg-12 col-md-12 col-sm-12 col-xs-12 mt_75 mb_75';
	$sidebar_class = '';
}

if ( isset( $layout ) && $layout == 'left' ) {
	$layout_classes = 'left-sidebar';
}

?>

<div class="fl-page-content">
	<?php get_template_part( 'views/page-heading/style', 1 ); ?>

	<div class="page-content-inner <?php if ( isset( $layout ) && $layout != 'no' ) echo 'page-king-sidebar'; ?>">
		<div class="page-container container">
			<div class="row fl-page <?php echo esc_attr($layout_classes); ?>">
				<div id="main-content" class="<?php echo esc_attr( $content_class ); ?>">
					<?php
						while ( have_posts() ) : the_post();
							the_content();

							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) {
								comments_template();
							}
						endwhile;

						// Displays page-links
						wp_link_pages( array(
							'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'erado' ) . '</span>',
							'after'       => '</div>',
							'link_before' => '<span>',
							'link_after'  => '</span>',
							'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'erado' ) . ' </span>%',
							'separator'   => '<span class="screen-reader-text">, </span>',
						) );
					?>
				</div>

				<?php if ( isset( $layout ) && $layout != 'no' ) : ?>
					<div id="main-sidebar" class="<?php echo esc_attr( $sidebar_class ); ?>">
						<?php
							if ( is_active_sidebar( 'primary-sidebar' ) ) {
								dynamic_sidebar( 'primary-sidebar' );
							}
						?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div><!-- fl-page-content -->

<?php get_footer();
