<?php
get_header();

$layout = $blog_style = $content_class = $sidebar_class = $layout_classes = $class = $data = '';

// Get blog options
$layout = erado_get_option( 'blog-single-layout', 'left' );

// Render columns number
if ( $layout == 'left' ) {
	$content_class = 'col-lg-9 col-md-9 col-sm-8 col-xs-12';
	$sidebar_class = 'col-lg-3 col-md-3 col-sm-4 col-xs-12';
	$layout_classes = 'left-sidebar';
} elseif ( $layout == 'right' ) {
	$content_class = 'col-lg-9 col-md-9 col-sm-8 col-xs-12';
	$sidebar_class = 'col-lg-3 col-md-3 col-sm-4 col-xs-12';
	$layout_classes = 'right-sidebar';
} elseif ( $layout == 'no' ) {
	$content_class = 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
	$sidebar_class = '';
}

?>

<div class="fl-page-content">
	<?php get_template_part( 'views/page-heading/style', 1 ); ?>
	<div class="container mt_85 mb_75">
		<div class="fl-row row <?php echo esc_attr($layout_classes); ?>">

			<div id="main-content" class="<?php echo esc_attr( $content_class ); ?>">
				<?php
                while ( have_posts() ) : the_post();

                    get_template_part( 'views/post/content', 'single' );

                endwhile; // End of the loop.
				?>
			</div>

			<?php if ( isset( $layout ) && $layout != 'no' ) : ?>
				<div id="main-sidebar" class="<?php echo esc_attr( $sidebar_class ); ?>">
					<?php
						if ( is_active_sidebar( 'primary-sidebar' ) ) {
							dynamic_sidebar( 'primary-sidebar' );
						}
					?>
				</div>
			<?php endif; ?>

		</div>
	</div>
</div><!-- fl-page-content -->

<?php get_footer();
