<?php
    $topBarLanguage    = erado_get_option( 'show-language-box', 0 );
    $topBarCurrency    = erado_get_option( 'show-currency-box', 0 );
?>
<div class="fl-mobile-nav">
    <div class="menu-title flex between-xs"><?php esc_html_e( 'MENU', 'erado' ) ?><i class="close-menu"></i></div>
    <div class="top-mobile tc mb_25">
        <?php if ( $topBarLanguage ) : ?>
            <div class="header-block dib">
                <?php echo erado_language(); ?>
            </div>
        <?php endif; ?>
        <?php if ( class_exists( 'WooCommerce' ) && $topBarCurrency == 1 ) : ?>
            <div class="header-block dib">
                <?php echo erado_currency(); ?>
            </div>
            <div class="header-block dib">
                <div class="btn-group">
                    <?php if ( is_user_logged_in() ) : ?>
                        <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="dropdown-toggle"><?php esc_html_e('Sign in', 'erado'); ?></a>
                    <?php else : ?>
                        <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="dropdown-toggle"><?php esc_html_e('My Account', 'erado'); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <div class="search-block db mt_15">
            <?php get_search_form(); ?>
        </div>
    </div>
    <?php
    if ( has_nav_menu('primary-menu') ) {
        $args = array(
            'theme_location'  => 'primary-menu',
            'container_class' => 'mobile-menu-wrapper',
            'menu_class'      => 'mobile-menu',
        );
        wp_nav_menu( $args );
    }
    ?>
</div>
