<?php
$blog_column = erado_get_option( 'blog-column', '2' );

// DEMO
if ( isset( $_GET['column'] ) && $_GET['column'] == 2 ) {
	$blog_column = 2;
} elseif ( isset( $_GET['column'] ) && $_GET['column'] == 3 ) {
	$blog_column = 3;
} elseif ( isset( $_GET['column'] ) && $_GET['column'] == 4 ) {
	$blog_column = 4;
}

if ( $blog_column == 2 ) {
	$class = 'item col-md-6 col-sm-6 col-xs-12 mb_40';
} elseif ( $blog_column == 3 ) {
	$class = 'item col-md-4 col-sm-6 col-xs-12 mb_40';
} elseif ( $blog_column == 4 ) {
	$class = 'item col-md-3 col-sm-6 col-xs-12 mb_40';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( esc_attr($class) ); ?>>
	<div class="post-inner item-animation">
        <div class="post-thumbnail pr">
            <?php if ( has_post_thumbnail() ) : ?>
            <a href="<?php esc_url( the_permalink() ); ?>" class="db mb_20" rel="bookmark" title="<?php the_title(); ?>">
				<?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
            </a>
            <?php endif; ?>
        </div>
        <div class="post-content">
            <?php
                erado_post_title();
                erado_post_meta();
            ?>
        </div><!-- .post-content -->
        <div class="post-excerpt">
            <?php erado_post_excerpt( 24 ); ?>
            <?php erado_get_content(); ?>
        </div>

	</div>
</article><!-- #post-# -->
