<?php
	$show_feature_image   = erado_get_option('show-feature-image', 1);
	$show_related_posts   = erado_get_option('show-related-posts', 1);
	$show_post_navigation = erado_get_option('show-post-navigation', 1);
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('single-post'); ?>>
	<?php erado_post_title(); ?>
	<div class="social-meta mb_20">
		<?php erado_post_meta(); ?>
	</div>
	<?php
		if( isset($show_feature_image) && $show_feature_image == 1 ) {
			erado_post_thumbnail();
		}
	?>
	<div class="entry-content mb_40">
		<?php the_content(); ?>
	</div>

</article><!-- #post-# -->
<div class="clearfix"></div>
<?php

wp_link_pages( array(
	'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'erado' ) . '</span>',
	'after'       => '</div>',
	'link_before' => '<span>',
	'link_after'  => '</span>',
	'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'erado' ) . ' </span>%',
	'separator'   => '<span class="screen-reader-text">, </span>',
) );

erado_post_tags();

if( isset($show_post_navigation) && $show_post_navigation == 1 ) {
	erado_post_navigation();
}
if( isset($show_related_posts) && $show_related_posts == 1 ) {
	erado_related_post();
}

//If comments are open or we have at least one comment, load up the comment template.
if ( comments_open() || get_comments_number() ) :
	comments_template();
endif;
?>
