<?php if ( is_search() ) : // Only display Excerpts for Search ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class( 'item col-md-12 col-sm-12 col-xs-12 mb_50' ); ?>>
        <div class="post-inner item-animation">
            <div class="post-thumbnail pr">
                <?php if ( has_post_thumbnail() ) : ?>
                <a href="<?php esc_url( the_permalink() ); ?>" class="db mb_10" rel="bookmark" title="<?php the_title(); ?>">
                    <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
                </a>
                <?php endif; ?>
            </div>
            <div class="post-content">
                <?php
                    erado_post_title();
                    erado_post_meta();
                ?>
            </div><!-- .post-content -->
            <div class="post-excerpt">
                <?php erado_post_excerpt( 50 ); ?>
                <?php erado_get_content(); ?>
            </div>

        </div>
    </article><!-- #post-# -->
<?php else : ?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'item col-md-12 col-sm-12 col-xs-12 mb_50' ); ?>>
    <div class="post-inner item-animation">
        <div class="post-thumbnail pr">
            <?php if ( has_post_thumbnail() ) : ?>
            <a href="<?php esc_url( the_permalink() ); ?>" class="db mb_10" rel="bookmark" title="<?php the_title(); ?>">
                <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
            </a>
            <?php endif; ?>
        </div>
        <div class="post-content">
            <?php
                erado_post_title();
                erado_post_meta();
            ?>
        </div><!-- .post-content -->
        <div class="post-excerpt">
            <?php erado_post_excerpt( 50 ); ?>
            <?php erado_get_content(); ?>
        </div>

    </div>
</article><!-- #post-# -->
<?php endif; ?>