<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 8.6.0
 */

defined( 'ABSPATH' ) || exit;

$sidebar_class = $content_class = $layout_classes = $shop_container_class = '';

$shop_display    = get_option( 'woocommerce_shop_page_display' );
$shop_layout     = erado_get_option( 'wc-shop-layout', 'no' );
$shop_fullwidth  = erado_get_option( 'wc-shop-fullwidth', 0 );
$pagination_type = erado_get_option( 'wc-pagination-type', 'number-pagination' );

// DEMO
if ( isset( $_GET['sidebar'] ) && $_GET['sidebar'] != '' ) $shop_layout = $_GET['sidebar'];

if ( isset( $_GET['fullwidth'] ) && $_GET['fullwidth'] == 1 ) {
	$shop_fullwidth = true;
}

if ( isset($_GET['column']) && $_GET['column'] == 6 ) {
	$shop_fullwidth = true;
}

if ( isset($_GET['pagination']) && ( $_GET['pagination'] == 'number' ) ) {
	$pagination_type = 'number-pagination';
} elseif( isset($_GET['pagination']) && ( $_GET['pagination'] == 'loadmore' ) ) {
	$pagination_type = 'load-more';
} elseif( isset($_GET['pagination']) && ( $_GET['pagination'] == 'infinite' ) ) {
	$pagination_type = 'infinite-scroll';
}

/////
if ( $shop_fullwidth == 0 ) {
	$shop_container_class = 'container';
} else {
	$shop_container_class = 'shop-fullwidth container-fluid';
}

if ( $shop_layout == 'left' ) {
	$sidebar_class = 'col-md-3 col-sm-4 col-xs-12';
	$content_class = 'col-md-9 col-sm-8 col-xs-12 with-sidebar';
	$layout_classes = 'left-sidebar';
} elseif ( $shop_layout == 'right' ) {
	$sidebar_class = 'col-md-3 col-sm-4 col-xs-12';
	$content_class = 'col-md-9 col-sm-8 col-xs-12 with-sidebar';
} else {
	$sidebar_class = '';
	$content_class = 'fullwidth';
}


get_header( 'shop' );

$woocommerce_page_title = erado_get_option( 'wc-page-title', 1 );

if ( $woocommerce_page_title && function_exists('is_shop') && is_shop() ) {
	get_template_part( 'views/page-heading/style', 1 );
}

if ( ( function_exists('is_product_category') && is_product_category() ) || ( function_exists('is_product_tag') ) && is_product_tag() ) {
	get_template_part( 'views/page-heading/style', 1 );
}


?>
<div class="fl-page-content">
	<header class="woocommerce-products-header">
		<?php
		/**
		 * Hook: woocommerce_archive_description.
		 *
		 * @hooked woocommerce_taxonomy_archive_description - 10
		 * @hooked woocommerce_product_archive_description - 10
		 */
		do_action( 'woocommerce_archive_description' );
		?>
	</header>

	<div class="clearfix"></div>

	<div class="<?php echo esc_attr($shop_container_class); ?> mt_80 <?php if( $shop_display == 'subcategories' ) { echo 'mb_35';} else { echo 'mb_70'; }?>">
		<div class="row <?php echo esc_attr($layout_classes); ?>">

			<div id="main-content" class="<?php echo esc_attr($content_class); ?>">

			    <?php if ( have_posts() ) : ?>
					<?php if ( $shop_display == 'subcategories' || $shop_display == 'both' ) : ?>
						<div class="products sub-categories">
							<div class="row">
								<?php woocommerce_product_subcategories(); ?>
							</div>
						</div>
					<?php endif; ?>

					<?php
						if ( $shop_display != 'subcategories' ) {
							erado_woocommerce_filter();
						}
					?>

					<?php
						/**
						 * woocommerce_before_shop_loop hook.
						 *
						 * @hooked wc_print_notices - 10
						 */
						do_action( 'woocommerce_before_shop_loop' );
					?>
					<div class="clearfix"></div>

					<?php
					woocommerce_product_loop_start();

					if ( wc_get_loop_prop( 'total' ) ) {
						while ( have_posts() ) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 *
							 * @hooked WC_Structured_Data::generate_product_data() - 10
							 */
							do_action( 'woocommerce_shop_loop' );

							wc_get_template_part( 'content', 'product' );
						}
					}

					woocommerce_product_loop_end();

					?>

					<?php if ( 'number-pagination' == $pagination_type ) : ?>
						<?php if ( $shop_display != 'subcategories' ) : ?>
								<div class="shop-action-bottom pt_20 clearfix">
									<?php
										do_action('erado_woocommerce_result_count');

										/**
										 * woocommerce_after_shop_loop hook.
										 *
										 * @hooked woocommerce_pagination - 10
										 */
										do_action( 'woocommerce_after_shop_loop' );
									?>
								</div>
						<?php endif; ?>
					<?php else : ?>
						<?php

						/**
						 * woocommerce_after_shop_loop hook.
						 *
						 * @hooked woocommerce_pagination - 10
						 */
						do_action( 'woocommerce_after_shop_loop' );

						?>
					<?php endif; ?>

				<?php else : ?>

					<?php
						/**
						 * woocommerce_no_products_found hook.
						 *
						 * @hooked wc_no_products_found - 10
						 */
						do_action( 'woocommerce_no_products_found' );
					?>

				<?php endif; ?>

			</div>
			<!-- end content -->

			<?php if ( isset( $shop_layout ) && $shop_layout != 'no' ) : ?>
				<div id="main-sidebar" class="sidebar_cat <?php echo esc_attr($sidebar_class); ?>">
					<?php
						/**
						 * woocommerce_sidebar hook.
						 *
						 * @hooked woocommerce_get_sidebar - 10
						 */
						do_action( 'woocommerce_sidebar' );
					?>
				</div>
			<?php endif; ?>

		</div>
	</div>
</div>
<!-- fl-page-content -->

<?php get_footer( 'shop' ); ?>
