<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

// Classes array
$classes = array();

$product_box_style  = erado_get_option( 'wc-product-style', 'style-2' );
$show_category_name = erado_get_option( 'wc-category-name', 1 );
$show_wishlist      = erado_get_option( 'wc-wishlist', 1 );
$show_quickview     = erado_get_option( 'wc-quick-view', 1 );
$show_compare     	= erado_get_option( 'wc-compare', 1 );
$column             = erado_get_option( 'wc-product-column', 4 );
$show_rating 		= erado_get_option( 'wc-rating', 0 );


if ( isset($_GET['style']) && ( $_GET['style'] == '1' ) ) {
	$product_box_style = 'style-1';
} elseif ( isset($_GET['style']) && ( $_GET['style'] == '2' ) ) {
	$product_box_style = 'style-2';
} elseif ( isset($_GET['style']) && ( $_GET['style'] == '3' ) ) {
	$product_box_style = 'style-3';
} elseif ( isset($_GET['style']) && ( $_GET['style'] == '4' ) ) {
	$product_box_style = 'style-4';
} elseif ( isset($_GET['style']) && ( $_GET['style'] == '5' ) ) {
	$product_box_style = 'style-5';
}


if ( isset($_GET['show_quickview']) && ( $_GET['show_quickview'] == 0 ) ) {
	$show_quickview = false;
}

if ( isset($_GET['show_wishlist']) && ( $_GET['show_wishlist'] == 0 ) ) {
	$show_wishlist = false;
}

if ( isset($_GET['show_category_name']) && ( $_GET['show_category_name'] == 0 ) ) {
	$show_category_name = false;
}
if ( isset($_GET['show_compare']) && ( $_GET['show_compare'] == 0 ) ) {
	$show_quickview = false;
}
if ( isset($_GET['show_rating']) && ( $_GET['show_rating'] == 0 ) ) {
	$show_rating = false;
}

// DEMO
if ( isset( $_GET['column'] ) && $_GET['column'] == 2 ) {
	$column = 2;
} elseif ( isset( $_GET['column'] ) && $_GET['column'] == 3 ) {
	$column = 3;
} elseif ( isset( $_GET['column'] ) && $_GET['column'] == 4 ) {
	$column = 4;
} elseif ( isset( $_GET['column'] ) && $_GET['column'] == 6 ) {
	$column = 6;
}

if ( $column == 6 ) {
	$classes[] = 'item mb_20 col-lg-2 col-md-3 col-sm-4 col-xs-6';
}  elseif ( $column == 4 ) {
	$classes[] = 'item mb_20 col-lg-3 col-md-3 col-sm-4 col-xs-6';
} elseif( $column == 3 ) {
	$classes[] = 'item mb_20 col-lg-4 col-md-4 col-sm-4 col-xs-6';
} elseif ( $column == 2 ) {
	$classes[] = 'item mb_20 col-lg-6 col-md-6 col-sm-6 col-xs-6';
}


?>

<?php if ( ( function_exists( 'is_shop' ) && is_shop() ) || ( function_exists( 'is_product_category' ) && is_product_category() ) || ( function_exists( 'is_product_tag' ) && is_product_tag() ) ) : ?>
<div class="<?php echo implode( ' ', $classes ); ?>">
	<div class="item-animation">
<?php endif; ?>
	<?php
		/**
		 * woocommerce_before_shop_loop_item hook. // <div class="product-box">
		 *
		 * @hooked erado_before_shop_loop_product - 5
		 */
		do_action( 'woocommerce_before_shop_loop_item' );
	?>
	<?php if ($product_box_style == 'style-1') { ?>
		<div class= "style-1 <?php if ( ! $product->is_in_stock() ) {
		echo 'product-sold-out';
	} ?>">
			<div class="product-thumb pr oh">
				<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook.
				 *
				 * @hooked woocommerce_template_loop_product_link_open - 5
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 15
				 * @hooked erado_second_product_thumbnail - 15
				 * @hooked woocommerce_template_loop_product_link_close - 20
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );

				if ( $show_quickview ) : ?>
					<div class="btn-quickview-box">
						<span class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
							<?php esc_html_e('Quick View', 'erado');?>
						</span>
					</div>
				<?php endif; ?>

				<?php if ( $show_quickview ) : ?>
					<div class="quick-view-list">
						<span class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
							<?php esc_html_e('Quick View', 'erado');?>
						</span>
					</div>
				<?php endif; ?>

			</div>

			<div class="product-info">
				<div class="title-product middle-xs between-xs">

					<?php
					do_action( 'woocommerce_shop_loop_item_title' );
					?>

				</div>
				<?php if ( $show_category_name ) {
						echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="product-cat db mb_3"> ', '</span>' );
				} ?>
				<div class="middle-xs price-box">
					<?php
					/**
					 * woocommerce_after_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_template_loop_price - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item_title' );
					?>
				</div>
				<?php if ( $show_rating ) { ?>
					<div class="rating">
						<?php woocommerce_template_loop_rating(); ?>
					</div>
				<?php } ?>
				<div  class="box-action">
					<div>
						<?php
							if ( $show_compare ) {
								if ( class_exists( 'YITH_WCWL' )) :
									echo do_shortcode('[yith_compare_button]');
								endif;
							}
						?>
						<div class="add-to-cart">
						<?php woocommerce_template_loop_add_to_cart(); ?>
						</div>
						<?php
						if ( $show_wishlist ) {
							if ( class_exists( 'YITH_WCWL' )) :
								echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
							endif;
						}
						?>
					</div>
				</div>

				<div class="product-extra">
					<?php woocommerce_template_single_excerpt(); ?>
					<div class="add-to-cart">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</div>
					<?php
					if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) :
							echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
						endif;
					}
					?>
					<?php
						if ( $show_compare ) {
							if ( class_exists( 'YITH_WCWL' )) :
								echo do_shortcode('[yith_compare_button]');
							endif;
						}
					?>
				</div>

			</div>
		</div>
	<?php } elseif ($product_box_style == 'style-2') { ?>
		<div class="style-2 <?php if ( ! $product->is_in_stock() ) {
		echo 'product-sold-out';
	} ?>">
			<div class="product-thumb pr oh">
				<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook.
				 *
				 * @hooked woocommerce_template_loop_product_link_open - 5
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 15
				 * @hooked erado_second_product_thumbnail - 15
				 * @hooked woocommerce_template_loop_product_link_close - 20
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				<?php if ( $show_quickview ) : ?>
					<div class="quick-view-list">
						<span class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
							<?php esc_html_e('Quick View', 'erado');?>
						</span>
					</div>
				<?php endif; ?>
				<ul class="box-action-thumb">
					<?php if ( $show_quickview ) : ?>
						<li class="quick-view">
							<a class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>" title="<?php esc_html_e('Quick View', 'erado');?>">
								<?php esc_html_e('Quick View', 'erado');?>
							</a>
						</li>
					<?php endif; ?>
					<?php if ( $show_compare ) {
						if ( class_exists( 'YITH_WCWL' )) : ?>
						<li class="compare"> <?php echo do_shortcode('[yith_compare_button]'); ?> </li>
					<?php
						endif;
					} ?>
					<?php if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) : ?>
							<li class="wishlist"> <?php echo do_shortcode( '[yith_wcwl_add_to_wishlist]' ); ?> </li>

						<?php
						endif;
						}
					?>
					<li class="add-to-cart tooltip-left">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</li>
				</ul>

			</div>

			<div class="product-info">
				<div class="title-product middle-xs between-xs">

					<?php
					do_action( 'woocommerce_shop_loop_item_title' );
					?>

				</div>
				<?php if ( $show_category_name ) {
						echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="product-cat db mb_3"> ', '</span>' );
				} ?>
				<div class="middle-xs price-box">
					<?php
					/**
					 * woocommerce_after_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_template_loop_price - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item_title' );
					?>
				</div>
				<?php if ( $show_rating ) { ?>
					<div class="rating">
						<?php woocommerce_template_loop_rating(); ?>
					</div>
				<?php } ?>


				<div class="product-extra">
					<?php woocommerce_template_single_excerpt(); ?>

					<div class="add-to-cart">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</div>
					<?php
					if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) :
							echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
						endif;
					}
					?>
					<?php
						if ( $show_compare ) {
							if ( class_exists( 'YITH_WCWL' )) :
								echo do_shortcode('[yith_compare_button]');
							endif;
						}
					?>
				</div>

			</div>
		</div>
	<?php } elseif ($product_box_style == 'style-3') { ?>
		<div class= "style-3 <?php if ( ! $product->is_in_stock() ) {
		echo 'product-sold-out';
	} ?>">
			<div class="product-thumb pr oh">
				<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook.
				 *
				 * @hooked woocommerce_template_loop_product_link_open - 5
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 15
				 * @hooked erado_second_product_thumbnail - 15
				 * @hooked woocommerce_template_loop_product_link_close - 20
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );

				if ( $show_quickview ) : ?>
					<div class="btn-quickview-box">
						<span class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
							<?php esc_html_e('Quick View', 'erado');?>
						</span>
					</div>
				<?php endif; ?>
				<?php if ( $show_quickview ) : ?>
					<div class="quick-view-list">
						<span class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
							<?php esc_html_e('Quick View', 'erado');?>
						</span>
					</div>
				<?php endif; ?>
				<ul class="box-action-thumb3">

					<?php if ( $show_compare ) {
						if ( class_exists( 'YITH_WCWL' )) : ?>
						<li class="compare"> <?php echo do_shortcode('[yith_compare_button]'); ?> </li>
					<?php
						endif;
					} ?>

					<li class="add-to-cart tooltip-top">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</li>

					<?php if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) : ?>
							<li class="wishlist"> <?php echo do_shortcode( '[yith_wcwl_add_to_wishlist]' ); ?> </li>

						<?php
						endif;
						}
					?>
				</ul>

			</div>

			<div class="product-info">
				<div class="title-product middle-xs between-xs">

					<?php
					do_action( 'woocommerce_shop_loop_item_title' );
					?>

				</div>
				<?php if ( $show_category_name ) {
						echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="product-cat db mb_3"> ', '</span>' );
				} ?>
				<div class="middle-xs price-box">
					<?php
					/**
					 * woocommerce_after_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_template_loop_price - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item_title' );
					?>
				</div>
				<?php if ( $show_rating ) { ?>
					<div class="rating">
						<?php woocommerce_template_loop_rating(); ?>
					</div>
				<?php } ?>

				<div class="product-extra">
					<?php woocommerce_template_single_excerpt(); ?>
					<div class="add-to-cart">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</div>
					<?php
					if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) :
							echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
						endif;
					}
					?>
					<?php
						if ( $show_compare ) {
							if ( class_exists( 'YITH_WCWL' )) :
							echo do_shortcode('[yith_compare_button]');
							endif;
						}
					?>
				</div>

			</div>
		</div>
	<?php } elseif ($product_box_style == 'style-4') { ?>
		<div class= "style-4 <?php if ( ! $product->is_in_stock() ) {
		echo 'product-sold-out';
	} ?>">
			<div class="product-thumb pr oh">
				<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook.
				 *
				 * @hooked woocommerce_template_loop_product_link_open - 5
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 15
				 * @hooked erado_second_product_thumbnail - 15
				 * @hooked woocommerce_template_loop_product_link_close - 20
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );

				if ( $show_wishlist ) {
					if ( class_exists( 'YITH_WCWL' )) : ?>
						<div class="wishlist-style4"> <?php echo do_shortcode( '[yith_wcwl_add_to_wishlist]' ); ?> </div>

					<?php
					endif;
					}
				?>
				<?php if ( $show_quickview ) : ?>
					<div class="quick-view-list">
						<span class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
							<?php esc_html_e('Quick View', 'erado');?>
						</span>
					</div>
				<?php endif; ?>
				<div  class="box-action-thumb4">
					<div>
						<?php if ( $show_compare ) {
							if ( class_exists( 'YITH_WCWL' )) : ?>
							<div class="compare"> <?php echo do_shortcode('[yith_compare_button]'); ?> </div>
						<?php
							endif;
						} ?>

						<div class="add-to-cart">
							<?php woocommerce_template_loop_add_to_cart(); ?>
						</div>

						<?php if ( $show_quickview ) : ?>
							<div class="quick-view">
								<a class="button btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
									<?php esc_html_e('Quick View', 'erado');?></a>
							</div>
						<?php endif; ?>
					</div>
				</div>

			</div>

			<div class="product-info">
				<div class="title-product middle-xs between-xs">

					<?php
					do_action( 'woocommerce_shop_loop_item_title' );
					?>

				</div>
				<?php if ( $show_category_name ) {
						echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="product-cat db mb_3"> ', '</span>' );
				} ?>
				<div class="middle-xs price-box">
					<?php
					/**
					 * woocommerce_after_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_template_loop_price - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item_title' );
					?>
				</div>
				<?php if ( $show_rating ) { ?>
					<div class="rating">
						<?php woocommerce_template_loop_rating(); ?>
					</div>
				<?php } ?>

				<div class="product-extra">
					<?php woocommerce_template_single_excerpt(); ?>
					<div class="add-to-cart">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</div>
					<?php
					if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) :
							echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
						endif;
					}
					?>
					<?php
						if ( $show_compare ) {
							if ( class_exists( 'YITH_WCWL' )) :
								echo do_shortcode('[yith_compare_button]');
							endif;
						}
					?>
				</div>

			</div>
		</div>
	<?php } elseif ($product_box_style == 'style-5') { ?>
		<div class="style-5 <?php if ( ! $product->is_in_stock() ) {
		echo 'product-sold-out';
	} ?>">
			<div class="product-thumb pr oh">
				<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook.
				 *
				 * @hooked woocommerce_template_loop_product_link_open - 5
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 15
				 * @hooked erado_second_product_thumbnail - 15
				 * @hooked woocommerce_template_loop_product_link_close - 20
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				<?php if ( $show_quickview ) : ?>
					<div class="quick-view-list">
						<span class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>">
							<?php esc_html_e('Quick View', 'erado');?>
						</span>
					</div>
				<?php endif; ?>
				<ul class="box-action-thumb5">
					<?php if ( $show_quickview ) : ?>
						<li class="quick-view">
							<a class="btn-quickview tc" data-product="<?php echo esc_attr( $post->ID ); ?>" title="<?php esc_html_e('Quick View', 'erado');?>">
								<?php esc_html_e('Quick View', 'erado');?>
							</a>
						</li>
					<?php endif; ?>
					<?php if ( $show_compare ) {
						if ( class_exists( 'YITH_WCWL' )) : ?>
						<li class="compare"> <?php echo do_shortcode('[yith_compare_button]'); ?> </li>
					<?php
						endif;
					} ?>
					<?php if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) : ?>
							<li class="wishlist"> <?php echo do_shortcode( '[yith_wcwl_add_to_wishlist]' ); ?> </li>

						<?php
						endif;
						}
					?>
				</ul>
				<div class="add-to-cart_style-5">
					<div class="add-to-cart">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</div>
				</div>

			</div>

			<div class="product-info">
				<div class="title-product middle-xs between-xs">

					<?php
					do_action( 'woocommerce_shop_loop_item_title' );
					?>

				</div>
				<?php if ( $show_category_name ) {
						echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="product-cat db mb_3"> ', '</span>' );
				} ?>
				<div class="middle-xs price-box">
					<?php
					/**
					 * woocommerce_after_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_template_loop_price - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item_title' );
					?>
				</div>
				<?php if ( $show_rating ) { ?>
					<div class="rating">
						<?php woocommerce_template_loop_rating(); ?>
					</div>
				<?php } ?>


				<div class="product-extra">
					<?php woocommerce_template_single_excerpt(); ?>

					<div class="add-to-cart">
						<?php woocommerce_template_loop_add_to_cart(); ?>
					</div>
					<?php
					if ( $show_wishlist ) {
						if ( class_exists( 'YITH_WCWL' )) :
							echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
						endif;
					}
					?>
					<?php
						if ( $show_compare ) {
							if ( class_exists( 'YITH_WCWL' )) :
								echo do_shortcode('[yith_compare_button]');
							endif;
						}
					?>
				</div>

			</div>
		</div>
	<?php } ?>

	<?php
		/**
		 * woocommerce_after_shop_loop_item hook. // </div>
		 *
		 * @hooked erado_after_shop_loop_product - 5
		 */
		do_action( 'woocommerce_after_shop_loop_item' );
	?>
<?php if ( ( function_exists( 'is_shop' ) && is_shop() ) || ( function_exists( 'is_product_category' ) && is_product_category() ) || ( function_exists( 'is_product_tag' ) && is_product_tag() ) ) : ?>
	</div>
</div>
<?php endif; ?>
