<?php
/**
 * Product quantity inputs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/quantity-input.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 7.8.0
 */

defined( 'ABSPATH' ) || exit;

if ( $max_value && $min_value === $max_value ) {
	?>
	<div class="quantity hidden">
		<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" class="qty" name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $min_value ); ?>" />
	</div>
	<?php
} else {
	?>
	<div class="quantity pr fl mr_10">
		<input type="number" id="<?php echo esc_attr( $input_id ); ?>" class="input-text tc" step="<?php echo esc_attr( $step ); ?>" min="<?php echo esc_attr( $min_value ); ?>"  name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $input_value ); ?>" title="<?php echo esc_attr_x( 'Qty', 'Product quantity input tooltip', 'erado' ) ?>" size="4" />
		<div class="qty tc">
			<a class="plus db pa" href="javascript:void(0);">
				<i class="icon-plus"></i>
			</a>
			<a class="minus db pa" href="javascript:void(0);">
				<i class="icon-minus"></i>
			</a>
		</div>
	</div>
	<?php
}
