<?php
/**
 * Product Loop Start
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/loop-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

$data = $sizer = '';
$class = array();

$shop_style      = erado_get_option( 'wc-archive-style', 'grid' );
$shop_gutter     = erado_get_option( 'wc-gutter-space', 30 );
$shop_column     = erado_get_option( 'wc-product-column', 4 );
$pagination_type = erado_get_option( 'wc-pagination-type', 'number-pagination' );

// DEMO
if ( isset($_GET['pagination']) && ( $_GET['pagination'] == 'number' ) ) {
	$pagination_type = 'number-pagination';
} elseif( isset($_GET['pagination']) && ( $_GET['pagination'] == 'loadmore' ) ) {
	$pagination_type = 'load-more';
} elseif( isset($_GET['pagination']) && ( $_GET['pagination'] == 'infinite' ) ) {
	$pagination_type = 'infinite-scroll';
}

if( isset($_GET['style']) ) {
	$shop_style = $_GET['style'];
}

if( isset($_GET['column']) ) {
	$shop_column = $_GET['column'];
}

if ( isset($_GET['gutter']) ) {
	$shop_gutter = $_GET['gutter'];
}

if( isset($_GET['grid']) && $_GET['grid'] == 0 ) {
	$class[] = 'erado-list';
}

if( $shop_style == 'grid' ) {
	$class[] = 'product-grid';
} elseif ($shop_style == 'masonry') {
	$class[] = 'product-masonry';
	//$data  = 'data-masonry=\'{"selector":".item","layoutMode":"masonry","columnWidth":".item"}\'';
}

if ( isset($shop_gutter) ) {
	$class[] = 'product-spacing-' . $shop_gutter;
}

// Product columns
if ( ! wc_get_loop_prop( 'is_shortcode' ) ) {
	$value = ( isset($shop_column) && $shop_column != '' ) ? $shop_column : apply_filters( 'loop_shop_columns' ) ;
	wc_set_loop_prop( 'columns', $value );
	$class[] = 'product-columns-' . wc_get_loop_prop( 'columns' );
}

if ( isset($shop_gutter) && $shop_gutter == 0 ) {
	$class[] = 'no-gutter';
}

?>
<div class="product-layout-wrapper">
	<div class="wc-loading hide"></div>
	<div class="products product-layout <?php echo implode(' ', $class); ?>" <?php //echo wp_kses_post( $data ); ?>>
