<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$sidebar_class = $content_class = $position_sidebar_class = '';
$shop_layout = erado_get_option( 'wc-single-product-layout', 'no' );

//DEMO
if ( isset( $_GET['sidebar'] ) && $_GET['sidebar'] != '' ) $shop_layout = $_GET['sidebar'];

if ( $shop_layout == 'left' ) {
	$sidebar_class = 'col-md-3 col-sm-4 col-xs-12 sidebar';
	$content_class = 'col-md-9 col-sm-8 col-xs-12';
	$position_sidebar_class = ' left-sidebar';
} elseif ( $shop_layout == 'right' ) {
	$sidebar_class = 'col-md-3 col-sm-4 col-xs-12 sidebar';
	$content_class = 'col-md-9 col-sm-8 col-xs-12';
} else {
	$sidebar_class = '';
	$content_class = 'col-md-12 col-sm-12 col-xs-12';
}
get_header( 'shop' ); ?>

<div class="fl-page-content">
	<?php get_template_part( 'views/page-heading/style', 1 ); ?>

	<div class="wc-product-detail-layout-1">
		<div class="container mt_85 mb_20 <?php if(isset($position_sidebar_class)) echo esc_attr($position_sidebar_class); ?>">
			<div class="row">
				<div id="main-content" class="<?php echo esc_attr($content_class); ?>">

					<?php while ( have_posts() ) : the_post(); ?>

						<?php wc_get_template_part( 'content', 'single-product' ); ?>

					<?php endwhile; // end of the loop. ?>

				</div>
				<!-- end content -->

				<?php if ( $shop_layout != 'no' ) : ?>
					<div id="main-sidebar" class="<?php echo esc_attr($sidebar_class); ?>">
						<?php
							/**
							 * woocommerce_sidebar hook.
							 *
							 * @hooked woocommerce_get_sidebar - 10
							 */
							do_action( 'woocommerce_sidebar' );
						?>
					</div>
				<?php endif; ?>

			</div>
		</div>
	</div>

</div>
<!-- fl-page-content -->

<?php get_footer( 'shop' ); ?>
