<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $post, $product;

$attachment_count = count( $product->get_gallery_image_ids() );

$video_url = get_post_meta( get_the_ID(), 'wc-single-video', true );

// Get product single style
$product_style = get_post_meta( get_the_ID(), 'wc-single-style', true );
if ( empty($product_style) ) {
	$product_style = 1;
}

// Get product thumbnail position
$thumb_position = get_post_meta( get_the_ID(), 'wc-thumbnail-position', true );
if ( $product_style == '1' && empty($thumb_position) ) {
	$thumb_position = 'bottom';
}

// Get product featured video
$video = ( isset($video_url) ) ? $video_url : '';

$classes = array();

$classes[] = 'single-product-thumbnail pr clearfix';
$p_thumb[] = 'p-thumb images';

if ( $thumb_position && $product_style == 1 ) {
	$classes[] = $thumb_position;
}

if ( $attachment_count == 0 ) {
	$classes[] = 'no-nav';
}

$attr = '';
if ( $product_style == 1 ) {
	$attr = 'data-slick=\'{"slidesToShow": 1, "slidesToScroll": 1, "asNavFor": ".p-nav", "fade":true}\'';
	$p_thumb[] = 'thumbnail-slider';
}
elseif ( $product_style == 2 ) {
	$attr = 'data-masonry=\'{"selector":".p-item", "layoutMode":"masonry"}\'';
	$p_thumb[] = 'jms-masonry';

	if ( $attachment_count < 1 ) {
		$p_thumb[] = 'columns-full';
	}
}
else {
	if ( wp_is_mobile() ) {
		$attr = 'data-slick=\'{"responsive":[{"breakpoint": 767,"settings":{"slidesToShow": 1, "vertical": false, "arrows": true}}]}\'';
		$p_thumb[] = 'thumbnail-slider';
	} else {
		$attr = '';
	}
}

?>

<div class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="<?php echo esc_attr( implode( ' ', $p_thumb ) ); ?>" <?php echo wp_kses_post( $attr ); ?>>
		<?php
			if ( has_post_thumbnail() ) {
				$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
				$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, 'full' );
				$thumbnail_post    = get_post( $post_thumbnail_id );
				$image_title       = $thumbnail_post->post_content;

				$attributes = array(
					'title'                   => $image_title,
					'data-src'                => $full_size_image[0],
					'data-large_image'        => $full_size_image[0],
					'data-zoom-image'  		  => $full_size_image[0],
					'data-large_image_width'  => $full_size_image[1],
					'data-large_image_height' => $full_size_image[2],
				);

				$html  = '<div class="p-item woocommerce-product-gallery__image"><a href="' . esc_url( $full_size_image[0] ) . '" class="zoom" data-rel="prettyPhoto[product-gallery]">';
					$html .= get_the_post_thumbnail( $post->ID, 'shop_single', $attributes );
				$html .= '</a></div>';

			} else {
				$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
					$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'erado' ) );
				$html .= '</div>';
			}

			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, get_post_thumbnail_id( $post->ID ) );

			$attachment_ids = $product->get_gallery_image_ids();

			if ( $attachment_ids ) {
				foreach ( $attachment_ids as $attachment_id ) {
					$full_size_image  = wp_get_attachment_image_src( $attachment_id, 'full' );
					$thumbnail        = wp_get_attachment_image_src( $attachment_id, 'shop_thumbnail' );
					$thumbnail_post   = get_post( $attachment_id );
					$image_title      = $thumbnail_post->post_content;

					$attributes = array(
						'title'                   => $image_title,
						'data-src'                => $full_size_image[0],
						'data-large_image'        => $full_size_image[0],
						'data-large_image_width'  => $full_size_image[1],
						'data-large_image_height' => $full_size_image[2],
					);

					$html = '<div class="p-item woocommerce-product-gallery__image">';
						$html .= '<a href="' . esc_url( $full_size_image[0] ) . '" class="zoom" data-rel="prettyPhoto[product-gallery]">';
							$html .= wp_get_attachment_image( $attachment_id, 'shop_single', false, $attributes );
						$html .= '</a>';
					$html .= '</div>';

					echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $attachment_id );
				}
			}
		?>
	</div>

	<?php
		if ( $product_style == 1 && $thumb_position != 'outside' ) {
			do_action( 'woocommerce_product_thumbnails' );
		}
	?>

	<?php if ( isset( $video ) && ! empty( $video ) ) : ?>
		<div class="wc-single-video pa">
			<?php
				echo '<a href="' . esc_url( $video_url ) . '" class="wc-popup-url"><i class="fa fa-play pr"></i>' . esc_html__( 'View Video', 'erado' ) . '</a>';
			?>
		</div>
	<?php endif; ?>
</div>
