<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$shop_layout    = erado_get_option( 'wc-single-product-layout', 'no' );
$shop_fullwidth = erado_get_option( 'wc-single-product-fullwidth', 0 );
$description_product_related = erado_get_option( 'description-product-related');

//DEMO
if ( isset( $_GET['sidebar'] ) && $_GET['sidebar'] == 'left' ) {
	$shop_layout = 'left';
} elseif ( isset( $_GET['sidebar'] ) && $_GET['sidebar'] == 'right' ) {
	$shop_layout = 'right';
}

if ( $related_products ) : ?>

	<div class="related-product jmsproduct-box">
		<div class="addon-title mb_40">
			<h3><?php esc_html_e( 'Related products', 'erado' ); ?></h3>
			<?php if( isset( $description_product_related ) && ! empty( $description_product_related ) ) : ?>
	            <p class="description"><?php echo esc_attr($description_product_related); ?></p>
	        <?php endif; ?>
		</div>
		<?php if ( $shop_layout != 'no' ) : ?>
			<div class="related-carousel owl-theme owl-carousel" data-carousel='{"selector":".related-carousel", "itemDesktop": 3, "itemMedium": 3, "itemTablet": 2, "itemMobile": 1, "margin":30 , "nav":true}'>
		<?php elseif ( $shop_fullwidth == 1 ) : ?>
			<div class="related-carousel owl-theme owl-carousel" data-carousel='{"selector":".related-carousel", "itemDesktop": 5, "itemMedium": 3, "itemTablet": 2, "itemMobile": 1, "margin":30 , "nav":true}'>
		<?php else : ?>
			<div class="related-carousel owl-theme owl-carousel" data-carousel='{"selector":".related-carousel", "itemDesktop": 4, "itemMedium": 3, "itemTablet": 2, "itemMobile": 1, "margin":30 , "nav":true}'>
		<?php endif; ?>
			<?php foreach ( $related_products as $related_product ) : ?>

				<?php
				 	$post_object = get_post( $related_product->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object );
				?>
					<div class="item">
                        <?php wc_get_template_part( 'content', 'product' ); ?>
                    </div>

			<?php endforeach; ?>
		</div>
	</div>

<?php endif;

wp_reset_postdata();
